/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfc;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzit;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgz
extends zzfc<Integer>
implements zzhe<Integer>,
zzit,
RandomAccess {
    private static final zzgz zzxu = new zzgz(new int[0], 0);
    private int[] zzxv;
    private int size;

    public static zzgz zzgm() {
        return zzxu;
    }

    zzgz() {
        this(new int[10], 0);
    }

    private zzgz(int[] nArray, int n) {
        this.zzxv = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdr();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzxv, n2, this.zzxv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgz)) {
            return super.equals(object);
        }
        zzgz zzgz2 = (zzgz)object;
        if (this.size != zzgz2.size) {
            return false;
        }
        int[] nArray = zzgz2.zzxv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzxv[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzxv[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzaf(n);
        return this.zzxv[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzxv[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbm(int n) {
        this.zzdr();
        if (this.size == this.zzxv.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzxv, 0, nArray, 0, this.size);
            this.zzxv = nArray;
        }
        this.zzxv[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzdr();
        zzgy.checkNotNull(collection);
        if (!(collection instanceof zzgz)) {
            return super.addAll(collection);
        }
        zzgz zzgz2 = (zzgz)collection;
        if (zzgz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgz2.size;
        if (n > this.zzxv.length) {
            this.zzxv = Arrays.copyOf(this.zzxv, n);
        }
        System.arraycopy(zzgz2.zzxv, 0, this.zzxv, this.size, zzgz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdr();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzxv[i])) continue;
            System.arraycopy(this.zzxv, i + 1, this.zzxv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzgz zzgz2 = this;
        zzgz2.zzdr();
        zzgz2.zzaf(n);
        int n4 = zzgz2.zzxv[n];
        zzgz2.zzxv[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgz zzgz2 = this;
        zzgz2.zzdr();
        zzgz2.zzaf(n);
        int n2 = zzgz2.zzxv[n];
        if (n < zzgz2.size - 1) {
            System.arraycopy(zzgz2.zzxv, n + 1, zzgz2.zzxv, n, zzgz2.size - n - 1);
        }
        --zzgz2.size;
        ++zzgz2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzgz zzgz2 = this;
        zzgz2.zzdr();
        if (n < 0 || n > zzgz2.size) {
            throw new IndexOutOfBoundsException(zzgz2.zzag(n));
        }
        if (zzgz2.size < zzgz2.zzxv.length) {
            System.arraycopy(zzgz2.zzxv, n, zzgz2.zzxv, n + 1, zzgz2.size - n);
        } else {
            int[] nArray = new int[zzgz2.size * 3 / 2 + 1];
            System.arraycopy(zzgz2.zzxv, 0, nArray, 0, n);
            System.arraycopy(zzgz2.zzxv, n, nArray, n + 1, zzgz2.size - n);
            zzgz2.zzxv = nArray;
        }
        zzgz2.zzxv[n] = n3;
        ++zzgz2.size;
        ++zzgz2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzbm(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzhe zzah(int n) {
        int n2 = n;
        zzgz zzgz2 = this;
        if (n2 < zzgz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgz(Arrays.copyOf(zzgz2.zzxv, n2), zzgz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzxu.zzdq();
    }
}

