/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context zzg;
    private final Object zzh = new Object();
    @GuardedBy(value="cameraLock")
    private Camera zzi;
    private int facing = 0;
    private int rotation;
    private Size zzj;
    private float zzk = 30.0f;
    private int zzl = 1024;
    private int zzm = 768;
    private boolean zzn = false;
    private String zzo;
    private SurfaceTexture zzp;
    private boolean zzq;
    private Thread zzr;
    private zza zzs;
    private Map<byte[], ByteBuffer> zzt = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzh;
        synchronized (object) {
            this.stop();
            this.zzs.release();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzh;
        synchronized (object) {
            if (this.zzi != null) {
                return this;
            }
            this.zzi = this.zzb();
            this.zzp = new SurfaceTexture(100);
            this.zzi.setPreviewTexture(this.zzp);
            this.zzq = true;
            this.zzi.startPreview();
            this.zzr = new Thread(this.zzs);
            this.zzr.setName("gms.vision.CameraSource");
            this.zzs.setActive(true);
            this.zzr.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzh;
        synchronized (object) {
            if (this.zzi != null) {
                return this;
            }
            this.zzi = this.zzb();
            this.zzi.setPreviewDisplay(surfaceHolder);
            this.zzi.startPreview();
            this.zzr = new Thread(this.zzs);
            this.zzs.setActive(true);
            this.zzr.start();
            this.zzq = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzs.setActive(false);
            if (this.zzr != null) {
                try {
                    this.zzr.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzr = null;
            }
            if (this.zzi != null) {
                this.zzi.stopPreview();
                this.zzi.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzq) {
                        this.zzi.setPreviewTexture(null);
                    } else {
                        this.zzi.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.zzi.release();
                this.zzi = null;
            }
            this.zzt.clear();
            return;
        }
    }

    public Size getPreviewSize() {
        return this.zzj;
    }

    public int getCameraFacing() {
        return this.facing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.zzh;
        synchronized (object) {
            if (this.zzi != null) {
                zzd zzd2 = new zzd(null);
                zzd2.zzag = shutterCallback;
                zzc zzc2 = new zzc(null);
                zzc2.zzaf = pictureCallback;
                this.zzi.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
            return;
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private final Camera zzb() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        block25: {
            int n8 = this.facing;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (n7 = 0; n7 < Camera.getNumberOfCameras(); ++n7) {
                Camera.getCameraInfo((int)n7, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n8) continue;
                n6 = n7;
                break block25;
            }
            n6 = n5 = -1;
        }
        if (n6 == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n5);
        n7 = this.zzm;
        int n9 = this.zzl;
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block7: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block7;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        Object object2 = arrayList;
        zze zze2 = null;
        int n10 = Integer.MAX_VALUE;
        ArrayList<zze> arrayList2 = object2;
        int n11 = arrayList2.size();
        Camera.CameraInfo cameraInfo = null;
        for (int i = 0; i < n11; ++i) {
            Object e = arrayList2.get(i);
            object = (zze)e;
            Size size = ((zze)object).zzc();
            n4 = Math.abs(size.getWidth() - n9) + Math.abs(size.getHeight() - n7);
            if (n4 >= n10) continue;
            zze2 = object;
            n10 = n4;
        }
        zze zze3 = zze2;
        if (zze3 == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size size = zze3.zzd();
        this.zzj = zze3.zzc();
        float f = this.zzk;
        Object object3 = camera;
        n7 = (int)(f * 1000.0f);
        object2 = null;
        int n12 = Integer.MAX_VALUE;
        cameraInfo = object3.getParameters().getSupportedPreviewFpsRange().iterator();
        while (cameraInfo.hasNext()) {
            object = (int[])cameraInfo.next();
            int n13 = n7 - object[0];
            n4 = n7 - object[1];
            int n14 = Math.abs(n13) + Math.abs(n4);
            if (n14 >= n12) continue;
            object2 = object;
            n12 = n14;
        }
        Object object4 = object2;
        if (object4 == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters2 = camera.getParameters();
        if (size != null) {
            parameters2.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters2.setPreviewSize(this.zzj.getWidth(), this.zzj.getHeight());
        parameters2.setPreviewFpsRange(object4[0], object4[1]);
        parameters2.setPreviewFormat(17);
        n12 = n3 = ((WindowManager)this.zzg.getSystemService("window")).getDefaultDisplay().getRotation();
        int n15 = n5;
        Camera.Parameters parameters3 = parameters2;
        Camera camera2 = camera;
        object3 = this;
        n10 = 0;
        switch (n12) {
            case 0: {
                n10 = 0;
                break;
            }
            case 1: {
                n10 = 90;
                break;
            }
            case 2: {
                n10 = 180;
                break;
            }
            case 3: {
                n10 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n12).toString());
            }
        }
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n15, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n2 = (cameraInfo.orientation + n10) % 360;
            n = (360 - n2) % 360;
        } else {
            n = n2 = (cameraInfo.orientation - n10 + 360) % 360;
        }
        object3.rotation = n2 / 90;
        camera2.setDisplayOrientation(n);
        parameters3.setRotation(n2);
        if (this.zzo != null) {
            if (parameters2.getSupportedFocusModes().contains(this.zzo)) {
                parameters2.setFocusMode(this.zzo);
            } else {
                Log.w((String)"CameraSource", (String)String.format("FocusMode %s is not supported on this device.", this.zzo));
                this.zzo = null;
            }
        }
        if (this.zzo == null && this.zzn) {
            if (parameters2.getSupportedFocusModes().contains("continuous-video")) {
                parameters2.setFocusMode("continuous-video");
                this.zzo = "continuous-video";
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters2);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zzb(null));
        camera.addCallbackBuffer(this.zza(this.zzj));
        camera.addCallbackBuffer(this.zza(this.zzj));
        camera.addCallbackBuffer(this.zza(this.zzj));
        camera.addCallbackBuffer(this.zza(this.zzj));
        return camera;
    }

    @SuppressLint(value={"InlinedApi"})
    private final byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        byte[] byArray = new byte[(int)Math.ceil((double)(size.getHeight() * size.getWidth() * n) / 8.0) + 1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzt.put(byArray, byteBuffer);
        return byArray;
    }

    /* synthetic */ CameraSource(com.google.android.gms.vision.zza zza2) {
        this();
    }

    final class zza
    implements Runnable {
        private Detector<?> zzx;
        private long zzz = SystemClock.elapsedRealtime();
        private final Object lock = new Object();
        private boolean zzaa = true;
        private long zzab;
        private int zzac = 0;
        private ByteBuffer zzad;

        zza(Detector<?> detector) {
            this.zzx = detector;
        }

        @SuppressLint(value={"Assert"})
        final void release() {
            this.zzx.release();
            this.zzx = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setActive(boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                this.zzaa = bl;
                this.lock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(byte[] byArray, Camera camera) {
            Object object = this.lock;
            synchronized (object) {
                if (this.zzad != null) {
                    camera.addCallbackBuffer(this.zzad.array());
                    this.zzad = null;
                }
                if (!CameraSource.this.zzt.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zzab = SystemClock.elapsedRealtime() - this.zzz;
                ++this.zzac;
                this.zzad = (ByteBuffer)CameraSource.this.zzt.get(byArray);
                this.lock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public final void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.lock;
                synchronized (object) {
                    while (this.zzaa && this.zzad == null) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzaa) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzad, CameraSource.this.zzj.getWidth(), CameraSource.this.zzj.getHeight(), 17).setId(this.zzac).setTimestampMillis(this.zzab).setRotation(CameraSource.this.rotation).build();
                    byteBuffer = this.zzad;
                    this.zzad = null;
                }
                try {
                    this.zzx.receiveFrame(frame);
                    continue;
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)exception);
                    continue;
                }
                finally {
                    CameraSource.this.zzi.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    final class zzb
    implements Camera.PreviewCallback {
        private zzb() {
        }

        public final void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.zzs.zza(byArray, camera);
        }

        /* synthetic */ zzb(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zze {
        private Size zzaj;
        private Size zzak;

        public zze(Camera.Size size, @Nullable Camera.Size size2) {
            this.zzaj = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzak = new Size(size2.width, size2.height);
            }
        }

        public final Size zzc() {
            return this.zzaj;
        }

        @Nullable
        public final Size zzd() {
            return this.zzak;
        }
    }

    final class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzaf;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zzaf != null) {
                this.zzaf.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.zzh;
            synchronized (object) {
                if (CameraSource.this.zzi != null) {
                    CameraSource.this.zzi.startPreview();
                }
                return;
            }
        }

        /* synthetic */ zzc(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    static final class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzag;

        private zzd() {
        }

        public final void onShutter() {
            if (this.zzag != null) {
                this.zzag.onShutter();
            }
        }

        /* synthetic */ zzd(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzx;
        private CameraSource zzy = new CameraSource(null);

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzx = detector;
            this.zzy.zzg = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzy.zzk = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzy.zzl = n;
            this.zzy.zzm = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzy.facing = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzy.zzn = bl;
            return this;
        }

        public Builder setFocusMode(String string) {
            if (!string.equals("continuous-video") && !string.equals("continuous-picture")) {
                Log.w((String)"CameraSource", (String)String.format("FocusMode %s is not supported for now.", string));
                string = null;
            }
            this.zzy.zzo = string;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzy;
            cameraSource.getClass();
            this.zzy.zzs = cameraSource.new zza(this.zzx);
            return this.zzy;
        }
    }
}

