/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zza;
    private Tracker<T> zzb;
    private int zzc = 3;
    private boolean zzd = false;
    private int zze;
    private int zzf = 0;

    public FocusingProcessor(@RecentlyNonNull Detector<T> detector, @RecentlyNonNull Tracker<T> tracker) {
        this.zza = detector;
        this.zzb = tracker;
    }

    @Override
    public void release() {
        this.zzb.onDone();
    }

    @Override
    public void receiveDetections(@RecentlyNonNull Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzf == this.zzc) {
                this.zzb.onDone();
                this.zzd = false;
            } else {
                this.zzb.onMissing(detections);
            }
            ++this.zzf;
            return;
        }
        this.zzf = 0;
        if (this.zzd) {
            Object object2 = sparseArray.get(this.zze);
            if (object2 != null) {
                this.zzb.onUpdate(detections, object2);
                return;
            }
            this.zzb.onDone();
            this.zzd = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzd = true;
        this.zze = n;
        this.zza.setFocus(this.zze);
        this.zzb.onNewItem(this.zze, object);
        this.zzb.onUpdate(detections, object);
    }

    public abstract int selectFocus(@RecentlyNonNull Detector.Detections<T> var1);

    protected final void zza(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzc = n;
    }
}

