/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzbxy;
    private SparseArray<zza> zzbxz = new SparseArray();
    private int zzbxm = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzbxz.size(); ++i) {
            Tracker tracker = ((zza)this.zzbxz.valueAt(i)).zzbxl;
            tracker.onDone();
        }
        this.zzbxz.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzbxz.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.zzbxl = this.zzbxy.create(object);
            zza2.zzbxl.onNewItem(n, object);
            this.zzbxz.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzbxz.size(); ++i) {
            int n = this.zzbxz.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzbxz.valueAt(i);
            zza2.zzbxp++;
            if (zza2.zzbxp >= this.zzbxm) {
                zza2.zzbxl.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.zzbxl.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.zzbxz.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.zzbxz.get(n);
            zza2.zzbxp = 0;
            zza2.zzbxl.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> zzbxl;
        private int zzbxp = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzbxA = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzbxA).zzbxy = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.zzbxA).zzbxm = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzbxA;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

