/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.internal.client.BoundingBoxParcel;
import com.google.android.gms.vision.text.internal.client.LineBoxParcel;
import com.google.android.gms.vision.text.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextBlock
implements Text {
    private LineBoxParcel[] zzbyo;
    private Point[] cornerPoints;
    private List<Line> zzbyp;
    private String zzbyq;
    private Rect zzbyr;

    TextBlock(SparseArray<LineBoxParcel> sparseArray) {
        this.zzbyo = new LineBoxParcel[sparseArray.size()];
        for (int i = 0; i < this.zzbyo.length; ++i) {
            this.zzbyo[i] = (LineBoxParcel)((Object)sparseArray.valueAt(i));
        }
    }

    @Override
    public String getLanguage() {
        if (this.zzbyq != null) {
            return this.zzbyq;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (LineBoxParcel lineBoxParcel : this.zzbyo) {
            int n = 0;
            if (hashMap.containsKey(lineBoxParcel.zzbyq)) {
                n = (Integer)hashMap.get(lineBoxParcel.zzbyq);
            }
            hashMap.put(lineBoxParcel.zzbyq, n + 1);
        }
        this.zzbyq = Collections.max(hashMap.entrySet(), new Comparator<Map.Entry<String, Integer>>(){

            public int zza(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry.getValue().compareTo(entry2.getValue());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.zza((Map.Entry)object, (Map.Entry)object2);
            }
        }).getKey();
        if (this.zzbyq == null || this.zzbyq.isEmpty()) {
            this.zzbyq = "und";
        }
        return this.zzbyq;
    }

    @Override
    public String getValue() {
        if (this.zzbyo.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbyo[0].zzbyA);
        for (int i = 1; i < this.zzbyo.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbyo[i].zzbyA);
        }
        return stringBuilder.toString();
    }

    void zzNa() {
        if (this.zzbyo.length == 0) {
            this.cornerPoints = new Point[0];
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.zzbyo.length; ++i) {
            Point[] pointArray = TextBlock.zza(this.zzbyo[i].zzbyx, this.zzbyo[0].zzbyx);
            for (int j = 0; j < 4; ++j) {
                Point point = pointArray[j];
                n = Math.min(n, point.x);
                n2 = Math.max(n2, point.x);
                n3 = Math.min(n3, point.y);
                n4 = Math.max(n4, point.y);
            }
        }
        this.cornerPoints = TextBlock.zza(n, n3, n2, n4, this.zzbyo[0].zzbyx);
    }

    private static Point[] zza(int n, int n2, int n3, int n4, BoundingBoxParcel boundingBoxParcel) {
        int n5 = boundingBoxParcel.left;
        int n6 = boundingBoxParcel.top;
        double d = Math.sin(Math.toRadians(boundingBoxParcel.zzbyv));
        double d2 = Math.cos(Math.toRadians(boundingBoxParcel.zzbyv));
        Point[] pointArray = new Point[]{new Point(n, n2), new Point(n3, n2), new Point(n3, n4), new Point(n, n4)};
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray[i].x * d2 - (double)pointArray[i].y * d);
            int n8 = (int)((double)pointArray[i].x * d + (double)pointArray[i].y * d2);
            pointArray[i].x = n7;
            pointArray[i].y = n8;
            pointArray[i].offset(n5, n6);
        }
        return pointArray;
    }

    private static Point[] zza(BoundingBoxParcel boundingBoxParcel, BoundingBoxParcel boundingBoxParcel2) {
        int n = -boundingBoxParcel2.left;
        int n2 = -boundingBoxParcel2.top;
        double d = Math.sin(Math.toRadians(boundingBoxParcel2.zzbyv));
        double d2 = Math.cos(Math.toRadians(boundingBoxParcel2.zzbyv));
        Point[] pointArray = new Point[4];
        pointArray[0] = new Point(boundingBoxParcel.left, boundingBoxParcel.top);
        pointArray[0].offset(n, n2);
        int n3 = (int)((double)pointArray[0].x * d2 + (double)pointArray[0].y * d);
        int n4 = (int)((double)(-pointArray[0].x) * d + (double)pointArray[0].y * d2);
        pointArray[0].x = n3;
        pointArray[0].y = n4;
        pointArray[1] = new Point(n3 + boundingBoxParcel.width, n4);
        pointArray[2] = new Point(n3 + boundingBoxParcel.width, n4 + boundingBoxParcel.height);
        pointArray[3] = new Point(n3, n4 + boundingBoxParcel.height);
        return pointArray;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            this.zzNa();
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        return this.zzNb();
    }

    List<Line> zzNb() {
        if (this.zzbyo.length == 0) {
            return new ArrayList<Line>(0);
        }
        if (this.zzbyp == null) {
            this.zzbyp = new ArrayList<Line>(this.zzbyo.length);
            for (LineBoxParcel lineBoxParcel : this.zzbyo) {
                this.zzbyp.add(new Line(lineBoxParcel));
            }
        }
        return this.zzbyp;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbyr == null) {
            this.zzbyr = zza.zza(this);
        }
        return this.zzbyr;
    }
}

