/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.hm;
import com.google.android.gms.internal.hq;
import com.google.android.gms.internal.il;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbQo;
    private boolean mCreated = false;
    private final zzj zzbQp = zzj.zza((Fragment)this);
    private final zzc zzbQq = new zzc(this, null);
    private zza zzbQr = new zza(this);
    private final Fragment zzaSF = this;
    private WalletFragmentOptions zzbQf;
    private WalletFragmentInitParams zzbQg;
    private MaskedWalletRequest zzbQh;
    private MaskedWallet zzbQi;
    private Boolean zzbQj;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaSF.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbQo != null) {
            this.zzbQo.initialize(walletFragmentInitParams);
            this.zzbQg = null;
            return;
        }
        if (this.zzbQg == null) {
            this.zzbQg = walletFragmentInitParams;
            if (this.zzbQh != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbQi != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbQo != null) {
            this.zzbQo.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbQh = null;
            return;
        }
        this.zzbQh = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbQo != null) {
            this.zzbQo.updateMaskedWallet(maskedWallet);
            this.zzbQi = null;
            return;
        }
        this.zzbQi = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzbQo != null) {
            this.zzbQo.setEnabled(bl);
            this.zzbQj = null;
            return;
        }
        this.zzbQj = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQr.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzbQo != null) {
            return this.zzbQo.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbQf == null) {
            this.zzbQf = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbQf);
        this.zzbQq.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbQg != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbQg = walletFragmentInitParams;
            }
            if (this.zzbQh == null) {
                this.zzbQh = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbQi == null) {
                this.zzbQi = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbQf = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbQj = bundle.getBoolean("enabled");
            }
        } else if (this.zzaSF.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaSF.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzby((Context)this.zzaSF.getActivity());
            this.zzbQf = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbQq.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbQq.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzbQq.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzbQq.onResume();
        FragmentManager fragmentManager = this.zzaSF.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaSF.getActivity()), (Activity)this.zzaSF.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzbQq.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzbQq.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbQq.onSaveInstanceState(bundle);
        if (this.zzbQg != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbQg);
            this.zzbQg = null;
        }
        if (this.zzbQh != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbQh);
            this.zzbQh = null;
        }
        if (this.zzbQi != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbQi);
            this.zzbQi = null;
        }
        if (this.zzbQf != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbQf);
            this.zzbQf = null;
        }
        if (this.zzbQj != null) {
            bundle.putBoolean("enabled", this.zzbQj.booleanValue());
            this.zzbQj = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbQo != null) {
            this.zzbQo.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzbQf = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzbQg = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzbQh = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzbQi = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzbQj = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends hq {
        private OnStateChangedListener zzbQs;
        private final WalletFragment zzbQt;

        zza(WalletFragment walletFragment) {
            this.zzbQt = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQs != null) {
                this.zzbQs.onStateChanged(this.zzbQt, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQs = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final hm zzbQm;

        private zzb(hm hm2) {
            this.zzbQm = hm2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQm.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzbQm.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQm.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQm.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzbQm.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQm.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzbQm.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzE((IObjectWrapper)this.zzbQm.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzbQm.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbQm.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbQm.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbQm.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQm.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQm.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(hm hm2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(hm2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzbQu;

        private zzc(WalletFragment walletFragment) {
            this.zzbQu = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzbQu.zzaSF.getActivity();
            if (this.zzbQu.zzbQo == null && this.zzbQu.mCreated && activity != null) {
                try {
                    hm hm2 = il.zza(activity, (zzk)this.zzbQu.zzbQp, this.zzbQu.zzbQf, this.zzbQu.zzbQr);
                    this.zzbQu.zzbQo = new zzb(hm2, null);
                    WalletFragment.zza(this.zzbQu, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzbQu.zzbQo);
                if (this.zzbQu.zzbQg != null) {
                    this.zzbQu.zzbQo.initialize(this.zzbQu.zzbQg);
                    WalletFragment.zza(this.zzbQu, null);
                }
                if (this.zzbQu.zzbQh != null) {
                    this.zzbQu.zzbQo.updateMaskedWalletRequest(this.zzbQu.zzbQh);
                    WalletFragment.zza(this.zzbQu, null);
                }
                if (this.zzbQu.zzbQi != null) {
                    this.zzbQu.zzbQo.updateMaskedWallet(this.zzbQu.zzbQi);
                    WalletFragment.zza(this.zzbQu, null);
                }
                if (this.zzbQu.zzbQj != null) {
                    this.zzbQu.zzbQo.setEnabled(this.zzbQu.zzbQj);
                    WalletFragment.zza(this.zzbQu, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzbQu.zzaSF.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzbQu.zzbQf != null && (walletFragmentStyle = this.zzbQu.zzbQf.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzbQu.zzaSF.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzbQu.zzaSF.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

