/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzddp;
import com.google.android.gms.internal.zzddq;
import com.google.android.gms.internal.zzddt;
import com.google.android.gms.internal.zzded;
import com.google.android.gms.internal.zzdee;
import com.google.android.gms.internal.zzdef;
import com.google.android.gms.internal.zzdeg;
import com.google.android.gms.internal.zzdeh;
import com.google.android.gms.internal.zzdei;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;

public final class zzdec
extends zzaa<zzddp> {
    private final Context mContext;
    private final int zzkpg;
    private final String zzdxe;
    private final int mTheme;
    private final boolean zzkph;

    public zzdec(Context context, Looper looper, zzq zzq2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.mContext = context;
        this.zzkpg = n;
        this.zzdxe = zzq2.getAccountName();
        this.mTheme = n2;
        this.zzkph = bl;
    }

    public final boolean zzajl() {
        return true;
    }

    protected final String zzhc() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String zzhd() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzew(int n) {
        Bundle bundle = this.zzbis();
        zzded zzded2 = new zzded((Activity)this.mContext, n);
        try {
            ((zzddp)this.zzajk()).zza(bundle, zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzdee)zzded2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzc(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.mContext;
        zzdec zzdec2 = this;
        Bundle bundle = zzdec2.zzbis();
        zzded zzded2 = new zzded(activity, n2);
        try {
            ((zzddp)zzdec2.zzajk()).zza(string4, string3, bundle, zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzdee)zzded2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdec zzdec2 = this;
        Bundle bundle = zzdec2.zzbis();
        zzded zzded2 = new zzded(activity, n2);
        try {
            ((zzddp)zzdec2.zzajk()).zza(maskedWalletRequest2, bundle, (zzddt)zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzdee)zzded2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdec zzdec2 = this;
        zzded zzded2 = new zzded(activity, n2);
        Bundle bundle = zzdec2.zzbis();
        try {
            ((zzddp)zzdec2.zzajk()).zza(fullWalletRequest2, bundle, (zzddt)zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzdee)zzded2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzded zzded2 = new zzded((Activity)this.mContext, n);
        Bundle bundle = this.zzbis();
        try {
            ((zzddp)this.zzajk()).zza(createWalletObjectsRequest, bundle, (zzddt)zzded2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdee)zzded2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzbis();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdeg zzdeg2 = new zzdeg(taskCompletionSource);
        try {
            ((zzddp)this.zzajk()).zza(createWalletObjectsRequest, bundle, (zzddt)zzdeg2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdee)zzdeg2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, zzn<BooleanResult> zzn2) {
        zzdeh zzdeh2 = new zzdeh(zzn2);
        Bundle bundle = this.zzbis();
        try {
            ((zzddp)this.zzajk()).zza(isReadyToPayRequest, bundle, (zzddt)zzdeh2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdee)zzdeh2).zza(Status.zzfhw, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzbis();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdei zzdei2 = new zzdei(taskCompletionSource);
        try {
            ((zzddp)this.zzajk()).zza(paymentDataRequest, bundle, (zzddt)zzdei2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzdee)zzdei2).zza(Status.zzfhw, null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzdef zzdef2 = new zzdef(taskCompletionSource);
        try {
            ((zzddp)this.zzajk()).zza(isReadyToPayRequest, this.zzbis(), (zzddt)zzdef2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdee)zzdef2).zza(Status.zzfhw, false, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzbis() {
        boolean bl = this.zzkph;
        int n = this.mTheme;
        String string = this.zzdxe;
        String string2 = this.mContext.getPackageName();
        int n2 = this.zzkpg;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzddp) {
            return (zzddp)iInterface;
        }
        return new zzddq(iBinder2);
    }
}

