/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.zzddk;
import com.google.android.gms.internal.zzddo;
import com.google.android.gms.internal.zzdej;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzkpr;
    private boolean mCreated = false;
    private final zzr zzkps = zzr.zza((Fragment)this);
    private final zzc zzkpt = new zzc(this, null);
    private zza zzkpu = new zza(this);
    private final Fragment zzgph = this;
    private WalletFragmentOptions zzkpv;
    private WalletFragmentInitParams zzkpw;
    private MaskedWalletRequest zzkpx;
    private MaskedWallet zzkpy;
    private Boolean zzkpz;

    public SupportWalletFragment() {
    }

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzgph.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzkpr != null) {
            this.zzkpr.initialize(walletFragmentInitParams);
            this.zzkpw = null;
            return;
        }
        if (this.zzkpw == null) {
            this.zzkpw = walletFragmentInitParams;
            if (this.zzkpx != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzkpy != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzkpr != null) {
            this.zzkpr.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzkpx = null;
            return;
        }
        this.zzkpx = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzkpr != null) {
            this.zzkpr.updateMaskedWallet(maskedWallet);
            this.zzkpy = null;
            return;
        }
        this.zzkpy = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzkpr != null) {
            this.zzkpr.setEnabled(bl);
            this.zzkpz = null;
            return;
        }
        this.zzkpz = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzkpu.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzkpr != null) {
            return this.zzkpr.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzkpv == null) {
            this.zzkpv = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzkpv);
        this.zzkpt.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzkpw != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzkpw = walletFragmentInitParams;
            }
            if (this.zzkpx == null) {
                this.zzkpx = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzkpy == null) {
                this.zzkpy = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzkpv = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzkpz = bundle.getBoolean("enabled");
            }
        } else if (this.zzgph.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgph.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzec((Context)this.zzgph.getActivity());
            this.zzkpv = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzkpt.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzkpt.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzkpt.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzkpt.onResume();
        FragmentManager fragmentManager = this.zzgph.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgph.getActivity()), (Activity)this.zzgph.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzkpt.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzkpt.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzkpt.onSaveInstanceState(bundle);
        if (this.zzkpw != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzkpw);
            this.zzkpw = null;
        }
        if (this.zzkpx != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzkpx);
            this.zzkpx = null;
        }
        if (this.zzkpy != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzkpy);
            this.zzkpy = null;
        }
        if (this.zzkpv != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzkpv);
            this.zzkpv = null;
        }
        if (this.zzkpz != null) {
            bundle.putBoolean("enabled", this.zzkpz.booleanValue());
            this.zzkpz = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzkpr != null) {
            this.zzkpr.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzkpv = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzkpw = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzkpx = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzkpy = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzkpz = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzddo {
        private OnStateChangedListener zzkqa;
        private final SupportWalletFragment zzkqb;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzkqb = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzkqa != null) {
                this.zzkqa.onStateChanged(this.zzkqb, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzkqa = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzddk zzkqc;

        private zzb(zzddk zzddk2) {
            this.zzkqc = zzddk2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzkqc.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzkqc.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzkqc.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzkqc.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzkqc.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzkqc.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzkqc.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzx((IObjectWrapper)this.zzkqc.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzkqc.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzkqc.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzkqc.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzkqc.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzkqc.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzkqc.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzddk zzddk2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(zzddk2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzkqd;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzkqd = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzkqd.zzgph.getActivity();
            if (this.zzkqd.zzkpr == null && this.zzkqd.mCreated && fragmentActivity != null) {
                try {
                    zzddk zzddk2 = zzdej.zza((Activity)fragmentActivity, (zzk)this.zzkqd.zzkps, this.zzkqd.zzkpv, this.zzkqd.zzkpu);
                    this.zzkqd.zzkpr = new zzb(zzddk2, null);
                    SupportWalletFragment.zza(this.zzkqd, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzkqd.zzkpr);
                if (this.zzkqd.zzkpw != null) {
                    this.zzkqd.zzkpr.initialize(this.zzkqd.zzkpw);
                    SupportWalletFragment.zza(this.zzkqd, null);
                }
                if (this.zzkqd.zzkpx != null) {
                    this.zzkqd.zzkpr.updateMaskedWalletRequest(this.zzkqd.zzkpx);
                    SupportWalletFragment.zza(this.zzkqd, null);
                }
                if (this.zzkqd.zzkpy != null) {
                    this.zzkqd.zzkpr.updateMaskedWallet(this.zzkqd.zzkpy);
                    SupportWalletFragment.zza(this.zzkqd, null);
                }
                if (this.zzkqd.zzkpz != null) {
                    this.zzkqd.zzkpr.setEnabled(this.zzkqd.zzkpz);
                    SupportWalletFragment.zza(this.zzkqd, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzkqd.zzgph.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzkqd.zzkpv != null && (walletFragmentStyle = this.zzkqd.zzkpv.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzkqd.zzgph.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzkqd.zzgph.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

