/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.wallet.zzd;
import com.google.android.gms.wallet.zze;
import java.util.ArrayList;
import java.util.Collection;

public final class CardRequirements
extends zzbej {
    public static final Parcelable.Creator<CardRequirements> CREATOR = new zze();
    ArrayList<Integer> zzkxc;
    boolean zzkxd;
    boolean zzkxe;
    int zzkxf;

    CardRequirements(ArrayList<Integer> arrayList, boolean bl, boolean bl2, int n) {
        this.zzkxc = arrayList;
        this.zzkxd = bl;
        this.zzkxe = bl2;
        this.zzkxf = n;
    }

    private CardRequirements() {
        this.zzkxd = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CardRequirements cardRequirements = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, cardRequirements.zzkxc, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (boolean)cardRequirements.zzkxd);
        zzbem.zza((Parcel)parcel2, (int)3, (boolean)cardRequirements.zzkxe);
        zzbem.zzc((Parcel)parcel2, (int)4, (int)cardRequirements.zzkxf);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzkxc;
    }

    public final boolean allowPrepaidCards() {
        return this.zzkxd;
    }

    public final boolean isBillingAddressRequired() {
        return this.zzkxe;
    }

    public final int getBillingAddressFormat() {
        return this.zzkxf;
    }

    public static Builder newBuilder() {
        return new Builder(new CardRequirements(), null);
    }

    public final class Builder {
        private /* synthetic */ CardRequirements zzkxg;

        private Builder(CardRequirements cardRequirements) {
            this.zzkxg = cardRequirements;
        }

        public final Builder addAllowedCardNetwork(int n) {
            if (this.zzkxg.zzkxc == null) {
                this.zzkxg.zzkxc = new ArrayList();
            }
            this.zzkxg.zzkxc.add(n);
            return this;
        }

        public final Builder addAllowedCardNetworks(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedCardNetworks can't be null or empty! You must provide a valid value from WalletConstants.CardNetwork.");
            if (this.zzkxg.zzkxc == null) {
                this.zzkxg.zzkxc = new ArrayList();
            }
            this.zzkxg.zzkxc.addAll(collection);
            return this;
        }

        public final Builder setAllowPrepaidCards(boolean bl) {
            this.zzkxg.zzkxd = bl;
            return this;
        }

        public final Builder setBillingAddressRequired(boolean bl) {
            this.zzkxg.zzkxe = bl;
            return this;
        }

        public final Builder setBillingAddressFormat(int n) {
            this.zzkxg.zzkxf = n;
            return this;
        }

        public final CardRequirements build() {
            zzbq.checkNotNull(this.zzkxg.zzkxc, (Object)"Allowed card networks must be non-empty! You can set it through addAllowedCardNetwork() or addAllowedCardNetworks() in the CardRequirements Builder.");
            return this.zzkxg;
        }

        /* synthetic */ Builder(CardRequirements cardRequirements, zzd zzd2) {
            this(cardRequirements);
        }
    }
}

