/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbgl {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zza;
    boolean zzb;
    CardRequirements zzc;
    boolean zzd;
    ShippingAddressRequirements zze;
    ArrayList<Integer> zzf;
    PaymentMethodTokenizationParameters zzg;
    TransactionInfo zzh;
    boolean zzi;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zza = bl;
        this.zzb = bl2;
        this.zzc = cardRequirements;
        this.zzd = bl3;
        this.zze = shippingAddressRequirements;
        this.zzf = arrayList;
        this.zzg = paymentMethodTokenizationParameters;
        this.zzh = transactionInfo;
        this.zzi = bl4;
    }

    private PaymentDataRequest() {
        this.zzi = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zza);
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzb);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzc, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzd);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zze, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzf, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzg, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzh, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzi);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zza;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzb;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzc;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzd;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zze;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzf;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzg;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzh;
    }

    public final boolean isUiRequired() {
        return this.zzi;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zza;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zza = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zza.zza = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zza.zzb = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zza.zzc = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zza.zzd = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zza.zze = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zza.zzf == null) {
                this.zza.zzf = new ArrayList();
            }
            this.zza.zzf.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbq.zzb((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zza.zzf == null) {
                this.zza.zzf = new ArrayList();
            }
            this.zza.zzf.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zza.zzg = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zza.zzh = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zza.zzi = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbq.zza(this.zza.zzf, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbq.zza((Object)((Object)this.zza.zzc), (Object)"Card requirements must be set!");
            if (this.zza.zzg != null) {
                zzbq.zza((Object)((Object)this.zza.zzh), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
            }
            return this.zza;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

