/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.zzdmd;
import com.google.android.gms.internal.zzdmh;
import com.google.android.gms.internal.zzdnc;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zza;
    private boolean zzb = false;
    private final zzj zzc = com.google.android.gms.dynamic.zzj.zza((Fragment)this);
    private final zzc zzd = new zzc(this, null);
    private zza zze = new zza(this);
    private final Fragment zzf = this;
    private WalletFragmentOptions zzg;
    private WalletFragmentInitParams zzh;
    private MaskedWalletRequest zzi;
    private MaskedWallet zzj;
    private Boolean zzk;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzf.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zza != null) {
            this.zza.zza(walletFragmentInitParams);
            this.zzh = null;
            return;
        }
        if (this.zzh == null) {
            this.zzh = walletFragmentInitParams;
            if (this.zzi != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzj != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zza != null) {
            this.zza.zza(maskedWalletRequest);
            this.zzi = null;
            return;
        }
        this.zzi = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zza != null) {
            this.zza.zza(maskedWallet);
            this.zzj = null;
            return;
        }
        this.zzj = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zza != null) {
            this.zza.zza(bl);
            this.zzk = null;
            return;
        }
        this.zzk = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zze.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zza != null) {
            return this.zza.zza();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzg == null) {
            this.zzg = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzg);
        this.zzd.zza(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzh != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzh = walletFragmentInitParams;
            }
            if (this.zzi == null) {
                this.zzi = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzj == null) {
                this.zzj = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzg = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzk = bundle.getBoolean("enabled");
            }
        } else if (this.zzf.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzf.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zza((Context)this.zzf.getActivity());
            this.zzg = walletFragmentOptions;
        }
        this.zzb = true;
        this.zzd.zza(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzd.zza(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzd.zzb();
    }

    public final void onResume() {
        super.onResume();
        this.zzd.zzc();
        FragmentManager fragmentManager = this.zzf.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzf.getActivity()), (Activity)this.zzf.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzd.zzd();
    }

    public final void onStop() {
        super.onStop();
        this.zzd.zze();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzd.zzb(bundle);
        if (this.zzh != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzh);
            this.zzh = null;
        }
        if (this.zzi != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzi);
            this.zzi = null;
        }
        if (this.zzj != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzj);
            this.zzj = null;
        }
        if (this.zzg != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzg);
            this.zzg = null;
        }
        if (this.zzk != null) {
            bundle.putBoolean("enabled", this.zzk.booleanValue());
            this.zzk = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzb = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zza != null) {
            this.zza.zza(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzg = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzh = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzi = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzj = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzk = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    @Hide
    static final class zza
    extends zzdmh {
        private OnStateChangedListener zza;
        private final WalletFragment zzb;

        zza(WalletFragment walletFragment) {
            this.zzb = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zza != null) {
                this.zza.onStateChanged(this.zzb, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zza = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzdmd zza;

        private zzb(zzdmd zzdmd2) {
            this.zza = zzdmd2;
        }

        private final void zza(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zza.zza(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void zza(boolean bl) {
            try {
                this.zza.zza(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void zza(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zza.zza(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void zza(MaskedWallet maskedWallet) {
            try {
                this.zza.zza(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int zza() {
            try {
                return this.zza.zze();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zza.zza(zzn.zza((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zza.zza(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zza((IObjectWrapper)this.zza.zza(zzn.zza((Object)layoutInflater), zzn.zza((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zza.zza();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zza.zzb();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zza.zzc();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zza.zzd();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zza.zzb(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void zza(int n, int n2, Intent intent) {
            try {
                this.zza.zza(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzdmd zzdmd2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzdmd2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zza;

        private zzc(WalletFragment walletFragment) {
            this.zza = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zza.zzf.getActivity();
            if (this.zza.zza == null && this.zza.zzb && activity != null) {
                try {
                    zzdmd zzdmd2 = zzdnc.zza(activity, (zzk)this.zza.zzc, this.zza.zzg, this.zza.zze);
                    this.zza.zza = new zzb(zzdmd2, null);
                    WalletFragment.zza(this.zza, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zza.zza);
                if (this.zza.zzh != null) {
                    this.zza.zza.zza(this.zza.zzh);
                    WalletFragment.zza(this.zza, null);
                }
                if (this.zza.zzi != null) {
                    this.zza.zza.zza(this.zza.zzi);
                    WalletFragment.zza(this.zza, null);
                }
                if (this.zza.zzj != null) {
                    this.zza.zza.zza(this.zza.zzj);
                    WalletFragment.zza(this.zza, null);
                }
                if (this.zza.zzk != null) {
                    this.zza.zza.zza(this.zza.zzk);
                    WalletFragment.zza(this.zza, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zza.zzf.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zza.zzg != null && (walletFragmentStyle = this.zza.zzg.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zza.zzf.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zza.zzf.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

