/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.wallet.zzd;
import com.google.android.gms.wallet.zze;
import java.util.ArrayList;
import java.util.Collection;

public final class CardRequirements
extends zzbgl {
    public static final Parcelable.Creator<CardRequirements> CREATOR = new zze();
    ArrayList<Integer> zzljo;
    boolean zzljp;
    boolean zzljq;
    int zzljr;

    CardRequirements(ArrayList<Integer> arrayList, boolean bl, boolean bl2, int n) {
        this.zzljo = arrayList;
        this.zzljp = bl;
        this.zzljq = bl2;
        this.zzljr = n;
    }

    private CardRequirements() {
        this.zzljp = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CardRequirements cardRequirements = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, cardRequirements.zzljo, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)cardRequirements.zzljp);
        zzbgo.zza((Parcel)parcel2, (int)3, (boolean)cardRequirements.zzljq);
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)cardRequirements.zzljr);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzljo;
    }

    public final boolean allowPrepaidCards() {
        return this.zzljp;
    }

    public final boolean isBillingAddressRequired() {
        return this.zzljq;
    }

    public final int getBillingAddressFormat() {
        return this.zzljr;
    }

    public static Builder newBuilder() {
        return new Builder(new CardRequirements(), null);
    }

    public final class Builder {
        private /* synthetic */ CardRequirements zzljs;

        private Builder(CardRequirements cardRequirements) {
            this.zzljs = cardRequirements;
        }

        public final Builder addAllowedCardNetwork(int n) {
            if (this.zzljs.zzljo == null) {
                this.zzljs.zzljo = new ArrayList();
            }
            this.zzljs.zzljo.add(n);
            return this;
        }

        public final Builder addAllowedCardNetworks(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedCardNetworks can't be null or empty! You must provide a valid value from WalletConstants.CardNetwork.");
            if (this.zzljs.zzljo == null) {
                this.zzljs.zzljo = new ArrayList();
            }
            this.zzljs.zzljo.addAll(collection);
            return this;
        }

        public final Builder setAllowPrepaidCards(boolean bl) {
            this.zzljs.zzljp = bl;
            return this;
        }

        public final Builder setBillingAddressRequired(boolean bl) {
            this.zzljs.zzljq = bl;
            return this;
        }

        public final Builder setBillingAddressFormat(int n) {
            this.zzljs.zzljr = n;
            return this;
        }

        public final CardRequirements build() {
            zzbq.checkNotNull(this.zzljs.zzljo, (Object)"Allowed card networks must be non-empty! You can set it through addAllowedCardNetwork() or addAllowedCardNetworks() in the CardRequirements Builder.");
            return this.zzljs;
        }

        /* synthetic */ Builder(CardRequirements cardRequirements, zzd zzd2) {
            this(cardRequirements);
        }
    }
}

