/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbgl {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zzlnc;
    boolean zzlnd;
    CardRequirements zzlne;
    boolean zzlnf;
    ShippingAddressRequirements zzlng;
    ArrayList<Integer> zzlld;
    PaymentMethodTokenizationParameters zzlnh;
    TransactionInfo zzlni;
    boolean zzlnj;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zzlnc = bl;
        this.zzlnd = bl2;
        this.zzlne = cardRequirements;
        this.zzlnf = bl3;
        this.zzlng = shippingAddressRequirements;
        this.zzlld = arrayList;
        this.zzlnh = paymentMethodTokenizationParameters;
        this.zzlni = transactionInfo;
        this.zzlnj = bl4;
    }

    private PaymentDataRequest() {
        this.zzlnj = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzlnc);
        zzbgo.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzlnd);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzlne, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzlnf);
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzlng, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzlld, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzlnh, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzlni, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzlnj);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzlnc;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzlnd;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzlne;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzlnf;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzlng;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzlld;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzlnh;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzlni;
    }

    public final boolean isUiRequired() {
        return this.zzlnj;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zzlnk;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zzlnk = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zzlnk.zzlnc = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zzlnk.zzlnd = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zzlnk.zzlne = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zzlnk.zzlnf = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zzlnk.zzlng = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zzlnk.zzlld == null) {
                this.zzlnk.zzlld = new ArrayList();
            }
            this.zzlnk.zzlld.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zzlnk.zzlld == null) {
                this.zzlnk.zzlld = new ArrayList();
            }
            this.zzlnk.zzlld.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zzlnk.zzlnh = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zzlnk.zzlni = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zzlnk.zzlnj = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbq.checkNotNull(this.zzlnk.zzlld, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbq.checkNotNull((Object)((Object)this.zzlnk.zzlne), (Object)"Card requirements must be set!");
            if (this.zzlnk.zzlnh != null) {
                zzbq.checkNotNull((Object)((Object)this.zzlnk.zzlni), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
            }
            return this.zzlnk;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

