/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzq;
import com.google.android.gms.wallet.zzr;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="IsReadyToPayRequestCreator")
public final class IsReadyToPayRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<IsReadyToPayRequest> CREATOR = new zzr();
    @SafeParcelable.Field(id=2)
    ArrayList<Integer> zzaj;
    @SafeParcelable.Field(id=4)
    private String zzbv;
    @SafeParcelable.Field(id=5)
    private String zzbw;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzbx;
    @SafeParcelable.Field(id=7)
    boolean zzby;
    @SafeParcelable.Field(id=8)
    private String zzbz;

    IsReadyToPayRequest() {
    }

    @SafeParcelable.Constructor
    IsReadyToPayRequest(@SafeParcelable.Param(id=2) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=4) String string, @SafeParcelable.Param(id=5) String string2, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList2, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) String string3) {
        this.zzaj = arrayList;
        this.zzbv = string;
        this.zzbw = string2;
        this.zzbx = arrayList2;
        this.zzby = bl;
        this.zzbz = string3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        IsReadyToPayRequest isReadyToPayRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)2, isReadyToPayRequest.zzaj, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)isReadyToPayRequest.zzbv, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)isReadyToPayRequest.zzbw, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, isReadyToPayRequest.zzbx, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)isReadyToPayRequest.zzby);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)isReadyToPayRequest.zzbz, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzaj;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzbx;
    }

    public final boolean isExistingPaymentMethodRequired() {
        return this.zzby;
    }

    public static IsReadyToPayRequest fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"isReadyToPayRequestJson cannot be null!");
        Builder builder = IsReadyToPayRequest.newBuilder();
        IsReadyToPayRequest.newBuilder().IsReadyToPayRequest.this.zzbz = string2;
        return builder.build();
    }

    public final String toJson() {
        return this.zzbz;
    }

    public static Builder newBuilder() {
        return new IsReadyToPayRequest().new Builder(null);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder addAllowedCardNetwork(int n) {
            if (IsReadyToPayRequest.this.zzaj == null) {
                IsReadyToPayRequest.this.zzaj = new ArrayList();
            }
            IsReadyToPayRequest.this.zzaj.add(n);
            return this;
        }

        public final Builder addAllowedCardNetworks(Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedCardNetworks can't be null or empty. If you want the defaults, leave it unset.");
            if (IsReadyToPayRequest.this.zzaj == null) {
                IsReadyToPayRequest.this.zzaj = new ArrayList();
            }
            IsReadyToPayRequest.this.zzaj.addAll(collection);
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (IsReadyToPayRequest.this.zzbx == null) {
                IsReadyToPayRequest.this.zzbx = new ArrayList();
            }
            IsReadyToPayRequest.this.zzbx.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty. If you want the default, leave it unset.");
            if (IsReadyToPayRequest.this.zzbx == null) {
                IsReadyToPayRequest.this.zzbx = new ArrayList();
            }
            IsReadyToPayRequest.this.zzbx.addAll(collection);
            return this;
        }

        public final Builder setExistingPaymentMethodRequired(boolean bl) {
            IsReadyToPayRequest.this.zzby = bl;
            return this;
        }

        public final IsReadyToPayRequest build() {
            return IsReadyToPayRequest.this;
        }

        /* synthetic */ Builder(zzq zzq2) {
            this();
        }
    }
}

