/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.internal.wallet.zze;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoResolveHelper {
    private static final long zzp = TimeUnit.MINUTES.toMillis(10L);
    @VisibleForTesting
    static long zzq = SystemClock.elapsedRealtime();
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        zza<TResult> zza2 = zza.zza(task);
        int n2 = zza2.zzu;
        activity.getFragmentManager().beginTransaction().add(zzb.zza(zza2.zzu, n), new StringBuilder(58).append("com.google.android.gms.wallet.AutoResolveHelper").append(n2).toString()).commit();
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)ApiExceptionUtil.fromStatus((Status)status));
    }

    private static void zza(Activity activity, int n, Task<? extends AutoResolvableResult> task) {
        if (activity.isFinishing()) {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                return;
            }
        } else {
            int n2;
            if (task.getException() instanceof ResolvableApiException) {
                ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                try {
                    resolvableApiException.startResolutionForResult(activity, n);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                        Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                    }
                    return;
                }
            }
            Intent intent = new Intent();
            if (task.isSuccessful()) {
                n2 = -1;
                ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            } else if (task.getException() instanceof ApiException) {
                ApiException apiException = (ApiException)task.getException();
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
            } else {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                    Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                }
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
            }
            AutoResolveHelper.zza(activity, n, n2, intent);
        }
    }

    private static void zza(Activity activity, int n, int n2, Intent intent) {
        block5: {
            PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
            if (pendingIntent == null) {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                    Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                    return;
                }
            } else {
                try {
                    pendingIntent.send(n2);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block5;
                    Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                }
            }
        }
    }

    @VisibleForTesting
    static final class zza<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult>,
    Runnable {
        @VisibleForTesting
        private static final Handler zzr = new zze(Looper.getMainLooper());
        @VisibleForTesting
        static final SparseArray<zza<?>> zzs = new SparseArray(2);
        private static final AtomicInteger zzt = new AtomicInteger();
        int zzu;
        private zzb zzv;
        private Task<TResult> zzw;

        zza() {
        }

        public static <TResult extends AutoResolvableResult> zza<TResult> zza(Task<TResult> task) {
            zza<TResult> zza2 = new zza<TResult>();
            new zza<TResult>().zzu = zzt.incrementAndGet();
            zzs.put(zza2.zzu, zza2);
            zzr.postDelayed(zza2, zzp);
            task.addOnCompleteListener(zza2);
            return zza2;
        }

        public final void zza(zzb zzb2) {
            this.zzv = zzb2;
            this.zzb();
        }

        public final void zzb(zzb zzb2) {
            if (this.zzv == zzb2) {
                this.zzv = null;
            }
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            this.zzw = task;
            this.zzb();
        }

        @Override
        public final void run() {
            zzs.delete(this.zzu);
        }

        private final void zzb() {
            if (this.zzw != null && this.zzv != null) {
                zzs.delete(this.zzu);
                zzr.removeCallbacks((Runnable)this);
                this.zzv.zzb((Task<? extends AutoResolvableResult>)this.zzw);
            }
        }
    }

    public static final class zzb
    extends Fragment {
        private static String zzx = "resolveCallId";
        private static String zzy = "requestCode";
        private static String zzz = "initializationElapsedRealtime";
        private static String zzaa = "delivered";
        private int zzab;
        private zza<?> zzac;
        @VisibleForTesting
        private boolean zzad;

        private static Fragment zza(int n, int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt(zzx, n);
            bundle.putInt(zzy, n2);
            bundle.putLong(zzz, zzq);
            zzb zzb2 = new zzb();
            zzb2.setArguments(bundle);
            return zzb2;
        }

        public final void onCreate(@Nullable Bundle bundle) {
            super.onCreate(bundle);
            this.zzab = this.getArguments().getInt(zzy);
            if (zzq != this.getArguments().getLong(zzz)) {
                this.zzac = null;
            } else {
                int n = this.getArguments().getInt(zzx);
                this.zzac = (zza)zza.zzs.get(n);
            }
            this.zzad = bundle != null && bundle.getBoolean(zzaa);
        }

        public final void onResume() {
            super.onResume();
            zzb zzb2 = this;
            if (zzb2.zzac != null) {
                zzb2.zzac.zza(zzb2);
                return;
            }
            if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                Log.w((String)"AutoResolveHelper", (String)"Sending canceled result for garbage collected task!");
            }
            zzb2.zzb(null);
        }

        public final void onSaveInstanceState(Bundle bundle) {
            super.onSaveInstanceState(bundle);
            bundle.putBoolean(zzaa, this.zzad);
            this.zzc();
        }

        public final void onPause() {
            super.onPause();
            this.zzc();
        }

        private final void zzc() {
            if (this.zzac != null) {
                this.zzac.zzb(this);
            }
        }

        private final void zzb(@Nullable Task<? extends AutoResolvableResult> task) {
            if (!this.zzad) {
                this.zzad = true;
                Activity activity = this.getActivity();
                activity.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
                if (task != null) {
                    AutoResolveHelper.zza(activity, this.zzab, (Task<? extends AutoResolvableResult>)task);
                    return;
                }
                AutoResolveHelper.zza(activity, this.zzab, 0, new Intent());
            }
        }
    }
}

