/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzo;
import com.google.android.gms.internal.wallet.zzq;
import com.google.android.gms.internal.wallet.zzr;
import com.google.android.gms.internal.wallet.zzu;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.internal.wallet.zzx;
import com.google.android.gms.internal.wallet.zzy;
import com.google.android.gms.internal.wallet.zzz;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.zzh;

public final class zzv
extends GmsClient<zzo> {
    private final Context zzer;
    private final int environment;
    private final String zzcc;
    private final int theme;
    private final boolean zzef;

    public zzv(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzer = context;
        this.environment = n;
        this.zzcc = clientSettings.getAccountName();
        this.theme = n2;
        this.zzef = bl;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzu zzu2 = new zzu((Activity)this.zzer, n);
        Bundle bundle = this.zzd();
        try {
            ((zzo)this.getService()).zza(createWalletObjectsRequest, bundle, (zzq)zzu2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzx)zzu2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzz zzz2 = new zzz(taskCompletionSource);
        try {
            ((zzo)this.getService()).zza(createWalletObjectsRequest, bundle, (zzq)zzz2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzx)zzz2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzw zzw2 = new zzw(taskCompletionSource);
        try {
            ((zzo)this.getService()).zza(isReadyToPayRequest, this.zzd(), (zzq)zzw2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzx)zzw2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzy zzy2 = new zzy(taskCompletionSource);
        try {
            ((zzo)this.getService()).zza(paymentDataRequest, bundle, (zzq)zzy2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzx)zzy2).zza(Status.RESULT_INTERNAL_ERROR, (PaymentData)null, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzd() {
        boolean bl = this.zzef;
        int n = this.theme;
        String string = this.zzcc;
        String string2 = this.zzer.getPackageName();
        int n2 = this.environment;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    public final int getMinApkVersion() {
        return 12600000;
    }

    public final Feature[] getApiFeatures() {
        return zzh.zzbg;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzo) {
            return (zzo)iInterface;
        }
        return new zzr(iBinder2);
    }
}

