/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.wobs.zzb;
import com.google.android.gms.wallet.zzm;
import com.google.android.gms.wallet.zzn;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzn();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zza;
    @SafeParcelable.Field(id=3)
    String zzb;
    @SafeParcelable.Field(id=4)
    String zzc;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzd;
    @SafeParcelable.Field(id=6)
    long zze;
    @SafeParcelable.Field(id=7)
    String zzf;
    @SafeParcelable.Field(id=8)
    long zzg;
    @SafeParcelable.Field(id=9)
    String zzh;

    public int getState() {
        return this.zza.zza();
    }

    public long getBalanceMicros() {
        return this.zze;
    }

    public long getBalanceUpdateTime() {
        return this.zzg;
    }

    @NonNull
    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    @NonNull
    public TimeInterval getValidTimeInterval() {
        return this.zza.zzc();
    }

    @NonNull
    public String getBalanceCurrencyCode() {
        return this.zzf;
    }

    @NonNull
    public String getBarcodeAlternateText() {
        return this.zza.zzd();
    }

    @Deprecated
    @NonNull
    public String getBarcodeLabel() {
        return this.zza.zze();
    }

    @NonNull
    public String getBarcodeType() {
        return this.zza.zzf();
    }

    @NonNull
    public String getBarcodeValue() {
        return this.zza.zzg();
    }

    @Deprecated
    @NonNull
    public String getCardIdentifier() {
        return this.zzd;
    }

    @NonNull
    public String getCardNumber() {
        return this.zzb;
    }

    @NonNull
    public String getClassId() {
        return this.zza.zzh();
    }

    @NonNull
    public String getEventNumber() {
        return this.zzh;
    }

    @NonNull
    public String getId() {
        return this.zza.zzi();
    }

    @Deprecated
    @NonNull
    public String getInfoModuleDataHexBackgroundColor() {
        return this.zza.zzj();
    }

    @Deprecated
    @NonNull
    public String getInfoModuleDataHexFontColor() {
        return this.zza.zzk();
    }

    @NonNull
    public String getIssuerName() {
        return this.zza.zzl();
    }

    @NonNull
    public String getPin() {
        return this.zzc;
    }

    @NonNull
    public String getTitle() {
        return this.zza.zzm();
    }

    @NonNull
    public ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zza.zzn();
    }

    @NonNull
    public ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zza.zzo();
    }

    @NonNull
    public ArrayList<UriData> getLinksModuleDataUris() {
        return this.zza.zzp();
    }

    @NonNull
    public ArrayList<LatLng> getLocations() {
        return this.zza.zzq();
    }

    @NonNull
    public ArrayList<WalletObjectMessage> getMessages() {
        return this.zza.zzr();
    }

    @NonNull
    public ArrayList<TextModuleData> getTextModulesData() {
        return this.zza.zzs();
    }

    GiftCardWalletObject() {
        this.zza = CommonWalletObject.zzb().zzz();
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        CommonWalletObject.zzb();
        this.zza = commonWalletObject;
        this.zzb = string;
        this.zzc = string2;
        this.zze = l;
        this.zzf = string4;
        this.zzg = l2;
        this.zzh = string5;
        this.zzd = string3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.zza, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.zze);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.zzg);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)9, (String)this.zzh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zza.zzt();
    }

    public final class Builder {
        private final zzb zzb = CommonWalletObject.zzb();

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addImageModuleDataMainImageUri(@NonNull UriData uri) {
            void var1_1;
            this.zzb.zza((UriData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addImageModuleDataMainImageUris(@NonNull Collection<UriData> uris) {
            void var1_1;
            this.zzb.zzb((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addInfoModuleDataLabelValueRow(@NonNull LabelValueRow row) {
            void var1_1;
            this.zzb.zzc((LabelValueRow)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addInfoModuleDataLabelValueRows(@NonNull Collection<LabelValueRow> rows) {
            void var1_1;
            this.zzb.zzd((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addLinksModuleDataUri(@NonNull UriData uri) {
            void var1_1;
            this.zzb.zze((UriData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addLinksModuleDataUris(@NonNull Collection<UriData> uris) {
            void var1_1;
            this.zzb.zzf((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addLocation(@NonNull LatLng location) {
            void var1_1;
            this.zzb.zzg((LatLng)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addLocations(@NonNull Collection<LatLng> locations) {
            void var1_1;
            this.zzb.zzh((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addMessage(@NonNull WalletObjectMessage message) {
            void var1_1;
            this.zzb.zzi((WalletObjectMessage)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addMessages(@NonNull Collection<WalletObjectMessage> messages) {
            void var1_1;
            this.zzb.zzj((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addTextModuleData(@NonNull TextModuleData data) {
            void var1_1;
            this.zzb.zzk((TextModuleData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addTextModulesData(@NonNull Collection<TextModuleData> data) {
            void var1_1;
            this.zzb.zzl((Collection)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBalanceCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            GiftCardWalletObject.this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBalanceMicros(long valueMicros) {
            void var1_1;
            GiftCardWalletObject.this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBalanceUpdateTime(long balanceUpdateTimeStamp) {
            void var1_1;
            GiftCardWalletObject.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBarcodeAlternateText(@NonNull String barcodeAlternateText) {
            void var1_1;
            this.zzb.zzm((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setBarcodeLabel(@NonNull String barcodeLabel) {
            void var1_1;
            this.zzb.zzn((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBarcodeType(@NonNull String barcodeType) {
            void var1_1;
            this.zzb.zzo((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBarcodeValue(@NonNull String barcodeValue) {
            void var1_1;
            this.zzb.zzp((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setCardIdentifier(@NonNull String cardIdentifier) {
            void var1_1;
            GiftCardWalletObject.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCardNumber(@NonNull String cardNumber) {
            void var1_1;
            GiftCardWalletObject.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setClassId(@NonNull String classId) {
            void var1_1;
            this.zzb.zzq((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEventNumber(@NonNull String eventNumber) {
            void var1_1;
            GiftCardWalletObject.this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setId(@NonNull String id) {
            void var1_1;
            this.zzb.zzr((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setInfoModuleDataHexBackgroundColor(@NonNull String color) {
            void var1_1;
            this.zzb.zzs((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setInfoModuleDataHexFontColor(@NonNull String color) {
            void var1_1;
            this.zzb.zzt((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setInfoModuleDataShowLastUpdateTime(boolean show) {
            void var1_1;
            this.zzb.zzu((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIssuerName(@NonNull String issuerName) {
            void var1_1;
            this.zzb.zzv((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPin(@NonNull String pin) {
            void var1_1;
            GiftCardWalletObject.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setState(int state) {
            void var1_1;
            this.zzb.zzx((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTitle(@NonNull String title) {
            void var1_1;
            this.zzb.zzw((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setValidTimeInterval(@NonNull TimeInterval interval) {
            void var1_1;
            this.zzb.zzy((TimeInterval)var1_1);
            return this;
        }

        @NonNull
        public GiftCardWalletObject build() {
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzb) ^ true), (Object)"Card number is required.");
            GiftCardWalletObject.this.zza = this.zzb.zzz();
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zza.zzm()) ^ true), (Object)"Card name is required.");
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zza.zzl()) ^ true), (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzm zzm2) {
        }
    }
}

