/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzcv;
import com.google.android.gms.wearable.internal.zzcx;
import com.google.android.gms.wearable.internal.zzm;
import java.io.IOException;
import java.io.InputStream;

public final class zzah
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient googleApiClient, final PutDataRequest putDataRequest) {
        return googleApiClient.zza((zzzv.zza)new zzm<DataApi.DataItemResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<DataApi.DataItemResult>)this, putDataRequest);
            }

            public DataApi.DataItemResult zzbT(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbT(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient googleApiClient, final Uri uri) {
        return googleApiClient.zza((zzzv.zza)new zzm<DataApi.DataItemResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbT(Status status) {
                return new zza(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbT(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzzv.zza)new zzm<DataItemBuffer>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zzx((zzzv.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzbU(Status status) {
                return new DataItemBuffer(DataHolder.zzcD((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbU(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.getDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zza((zzzv.zza)new zzm<DataItemBuffer>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<DataItemBuffer>)this, uri, n);
            }

            protected DataItemBuffer zzbU(Status status) {
                return new DataItemBuffer(DataHolder.zzcD((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbU(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.deleteDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zza((zzzv.zza)new zzm<DataApi.DeleteDataItemsResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zzb((zzzv.zzb<DataApi.DeleteDataItemsResult>)this, uri, n);
            }

            protected DataApi.DeleteDataItemsResult zzbV(Status status) {
                return new zzb(status, 0);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbV(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final Asset asset) {
        this.zza(asset);
        return googleApiClient.zza((zzzv.zza)new zzm<DataApi.GetFdForAssetResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbW(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbW(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final DataItemAsset dataItemAsset) {
        return googleApiClient.zza((zzzv.zza)new zzm<DataApi.GetFdForAssetResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<DataApi.GetFdForAssetResult>)this, dataItemAsset);
            }

            protected DataApi.GetFdForAssetResult zzbW(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbW(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzcv.zzis("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(googleApiClient, dataListener, intentFilterArray);
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, Uri uri, int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzcv.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        return this.zza(googleApiClient, dataListener, new IntentFilter[]{intentFilter});
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzah.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzcx zzcx2, zzzv.zzb<Status> zzb2, DataApi.DataListener dataListener, zzaaz<DataApi.DataListener> zzaaz2) throws RemoteException {
                zzcx2.zza(zzb2, dataListener, zzaaz2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, final DataApi.DataListener dataListener) {
        return googleApiClient.zza((zzzv.zza)new zzm<Status>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzzv.zzb<Status>)this, dataListener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status zzahq;
        private volatile ParcelFileDescriptor zzbSr;
        private volatile InputStream zzbSc;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzahq = status;
            this.zzbSr = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbSr;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbSr == null) {
                return null;
            }
            if (this.zzbSc == null) {
                this.zzbSc = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbSr);
            }
            return this.zzbSc;
        }

        public void release() {
            if (this.zzbSr == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzbSc != null) {
                    this.zzbSc.close();
                } else {
                    this.zzbSr.close();
                }
                this.mClosed = true;
                this.zzbSr = null;
                this.zzbSc = null;
            }
            catch (IOException iOException) {}
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status zzahq;
        private final int zzbSq;

        public zzb(Status status, int n) {
            this.zzahq = status;
            this.zzbSq = n;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public int getNumDeleted() {
            return this.zzbSq;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status zzahq;
        private final DataItem zzbSp;

        public zza(Status status, DataItem dataItem) {
            this.zzahq = status;
            this.zzbSp = dataItem;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbSp;
        }
    }
}

