/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcl;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzdi;
import com.google.android.gms.wearable.internal.zzdn;
import com.google.android.gms.wearable.internal.zzdo;
import com.google.android.gms.wearable.internal.zzdp;
import com.google.android.gms.wearable.internal.zzem;
import com.google.android.gms.wearable.internal.zzeu;
import com.google.android.gms.wearable.internal.zzfn;
import com.google.android.gms.wearable.internal.zzfr;
import com.google.android.gms.wearable.internal.zzfx;
import com.google.android.gms.wearable.internal.zzfy;
import com.google.android.gms.wearable.internal.zzfz;
import com.google.android.gms.wearable.internal.zzga;
import com.google.android.gms.wearable.internal.zzgh;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public final class zzfw
extends zzaa<zzdn> {
    private final ExecutorService zzbrZ;
    private final zzdp<Object> zzbTi = new zzdp();
    private final zzdp<Object> zzbTj = new zzdp();
    private final zzdp<ChannelApi.ChannelListener> zzbTk = new zzdp();
    private final zzdp<DataApi.DataListener> zzbTl = new zzdp();
    private final zzdp<MessageApi.MessageListener> zzbTm = new zzdp();
    private final zzdp<NodeApi.NodeListener> zzbTn = new zzdp();
    private final zzdp<Object> zzbTo = new zzdp();
    private final zzdp<CapabilityApi.CapabilityListener> zzbTp = new zzdp();
    private final zzgh zzbTq;

    public zzfw(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, zzq2, Executors.newCachedThreadPool(), zzgh.zzbz(context));
    }

    private zzfw(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2, ExecutorService executorService, zzgh zzgh2) {
        super(context, looper, 14, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzbrZ = (ExecutorService)zzbr.zzu((Object)executorService);
        this.zzbTq = zzgh2;
    }

    protected final String zzda() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected final String zzqX() {
        if (this.zzbTq.zzgo("com.google.android.wearable.app.cn")) {
            return "com.google.android.wearable.app.cn";
        }
        return "com.google.android.gms";
    }

    protected final String zzdb() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    public final boolean zzpc() {
        return !this.zzbTq.zzgo("com.google.android.wearable.app.cn");
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)new StringBuilder(41).append("onPostInitHandler: statusCode ").append(n).toString());
        }
        if (n == 0) {
            this.zzbTi.zzam(iBinder);
            this.zzbTj.zzam(iBinder);
            this.zzbTk.zzam(iBinder);
            this.zzbTl.zzam(iBinder);
            this.zzbTm.zzam(iBinder);
            this.zzbTn.zzam(iBinder);
            this.zzbTo.zzam(iBinder);
            this.zzbTp.zzam(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final void zza(@NonNull zzj zzj2) {
        if (!this.zzpc()) {
            try {
                Bundle bundle = this.getContext().getPackageManager().getApplicationInfo((String)"com.google.android.wearable.app.cn", (int)128).metaData;
                int n = bundle != null ? bundle.getInt("com.google.android.wearable.api.version", 0) : 0;
                if (n < zze.GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                    Intent intent;
                    Context context;
                    int n2 = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
                    Log.w((String)"WearableClient", (String)new StringBuilder(80).append("Android Wear out of date. Requires API version ").append(n2).append(" but found ").append(n).toString());
                    Context context2 = context = this.getContext();
                    Intent intent2 = new Intent("com.google.android.wearable.app.cn.UPDATE_ANDROID_WEAR").setPackage("com.google.android.wearable.app.cn");
                    if (context.getPackageManager().resolveActivity(intent2, 65536) != null) {
                        intent = intent2;
                    } else {
                        Uri uri = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", "com.google.android.wearable.app.cn").build();
                        intent = new Intent("android.intent.action.VIEW", uri);
                    }
                    this.zza(zzj2, 6, PendingIntent.getActivity((Context)context2, (int)0, (Intent)intent, (int)0));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zza(zzj2, 16, null);
                return;
            }
        }
        super.zza(zzj2);
    }

    public final void zza(zzbcl<DataApi.DataItemResult> zzbcl2, PutDataRequest putDataRequest) throws RemoteException {
        Object object = putDataRequest.getAssets().entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = object.next().getValue();
            if (object2.getData() != null || object2.getDigest() != null || object2.getFd() != null || object2.getUri() != null) continue;
            String string = String.valueOf(putDataRequest.getUri());
            String string2 = String.valueOf(object2);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Put for ").append(string).append(" contains invalid asset: ").append(string2).toString());
        }
        object = PutDataRequest.zzt(putDataRequest.getUri());
        ((PutDataRequest)((Object)object)).setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            ((PutDataRequest)((Object)object)).setUrgent();
        }
        ArrayList<FutureTask<Boolean>> arrayList = new ArrayList<FutureTask<Boolean>>();
        for (Map.Entry entry : putDataRequest.getAssets().entrySet()) {
            Object object3;
            Asset asset = (Asset)((Object)entry.getValue());
            if (asset.getData() != null) {
                String string;
                ParcelFileDescriptor[] parcelFileDescriptorArray;
                try {
                    parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    string = String.valueOf((Object)putDataRequest);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Unable to create ParcelFileDescriptor for asset in request: ").append(string).toString(), iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object3 = String.valueOf((Object)asset);
                    string = String.valueOf(parcelFileDescriptorArray[0]);
                    String string3 = String.valueOf(parcelFileDescriptorArray[1]);
                    Log.d((String)"WearableClient", (String)new StringBuilder(61 + String.valueOf(object3).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("processAssets: replacing data with FD in asset: ").append((String)object3).append(" read:").append(string).append(" write:").append(string3).toString());
                }
                ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
                byte[] byArray = asset.getData();
                ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
                zzfw zzfw2 = this;
                object3 = new FutureTask<Boolean>(new zzfx(zzfw2, parcelFileDescriptor, byArray));
                arrayList.add((FutureTask<Boolean>)object3);
                this.zzbrZ.submit((Runnable)object3);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    object3 = Asset.createFromFd(this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r"));
                    ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), (Asset)((Object)object3));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzfr(zzbcl2, arrayList).zza(new zzem(4005, null));
                    object3 = String.valueOf(asset.getUri());
                    Log.w((String)"WearableClient", (String)new StringBuilder(28 + String.valueOf(object3).length()).append("Couldn't resolve asset URI: ").append((String)object3).toString());
                    return;
                }
            }
            ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), asset);
        }
        ((zzdn)this.zzrd()).zza((zzdi)new zzfr(zzbcl2, arrayList), (PutDataRequest)((Object)object));
    }

    public final void zza(zzbcl<DataApi.GetFdForAssetResult> zzbcl2, Asset asset) throws RemoteException {
        ((zzdn)this.zzrd()).zza((zzdi)new zzfn(zzbcl2), asset);
    }

    public final void zza(zzbcl<Status> zzbcl2, String string, Uri uri, boolean bl) {
        try {
            boolean bl2 = bl;
            Uri uri2 = uri;
            String string2 = string;
            zzbcl<Status> zzbcl3 = zzbcl2;
            zzfw zzfw2 = this;
            zzbr.zzu(zzbcl3);
            zzbr.zzu((Object)string2);
            zzbr.zzu((Object)uri2);
            this.zzbrZ.execute(new zzfy(zzfw2, uri2, zzbcl3, bl2, string2));
            return;
        }
        catch (RuntimeException runtimeException) {
            zzbcl2.zzr(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(zzbcl<Status> zzbcl2, String string, Uri uri, long l, long l2) {
        try {
            long l3 = l2;
            long l4 = l;
            Uri uri2 = uri;
            String string2 = string;
            zzbcl<Status> zzbcl3 = zzbcl2;
            zzfw zzfw2 = this;
            zzbr.zzu(zzbcl3);
            zzbr.zzu((Object)string2);
            zzbr.zzu((Object)uri2);
            zzbr.zzb((l4 >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l4});
            zzbr.zzb((l3 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l3});
            this.zzbrZ.execute(new zzfz(zzfw2, uri2, zzbcl3, string2, l4, l3));
            return;
        }
        catch (RuntimeException runtimeException) {
            zzbcl2.zzr(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(zzbcl<Status> zzbcl2, DataApi.DataListener dataListener, zzbfi<DataApi.DataListener> zzbfi2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTl.zza(this, zzbcl2, dataListener, zzga.zza(zzbfi2, intentFilterArray));
    }

    public final void zza(zzbcl<Status> zzbcl2, MessageApi.MessageListener messageListener, zzbfi<MessageApi.MessageListener> zzbfi2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTm.zza(this, zzbcl2, messageListener, zzga.zzb(zzbfi2, intentFilterArray));
    }

    public final void zza(zzbcl<Status> zzbcl2, NodeApi.NodeListener nodeListener, zzbfi<NodeApi.NodeListener> zzbfi2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTn.zza(this, zzbcl2, nodeListener, zzga.zzc(zzbfi2, intentFilterArray));
    }

    public final void zza(zzbcl<Status> zzbcl2, CapabilityApi.CapabilityListener capabilityListener, zzbfi<CapabilityApi.CapabilityListener> zzbfi2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTp.zza(this, zzbcl2, capabilityListener, zzga.zze(zzbfi2, intentFilterArray));
    }

    public final void zza(zzbcl<Status> zzbcl2, ChannelApi.ChannelListener channelListener, zzbfi<ChannelApi.ChannelListener> zzbfi2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzbTk.zza(this, zzbcl2, channelListener, zzga.zzd(zzbfi2, intentFilterArray));
            return;
        }
        zzeu zzeu2 = new zzeu(string, channelListener);
        this.zzbTk.zza(this, zzbcl2, zzeu2, zzga.zza(zzbfi2, string, intentFilterArray));
    }

    public final void zza(zzbcl<Status> zzbcl2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbTl.zza(this, zzbcl2, dataListener);
    }

    public final void zza(zzbcl<Status> zzbcl2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbTm.zza(this, zzbcl2, messageListener);
    }

    public final void zza(zzbcl<Status> zzbcl2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbTn.zza(this, zzbcl2, nodeListener);
    }

    public final void zza(zzbcl<Status> zzbcl2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzbTp.zza(this, zzbcl2, capabilityListener);
    }

    public final void zza(zzbcl<Status> zzbcl2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbTk.zza(this, zzbcl2, channelListener);
            return;
        }
        zzeu zzeu2 = new zzeu(string, channelListener);
        this.zzbTk.zza(this, zzbcl2, zzeu2);
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wearable.internal.IWearableService");
        if (iInterface instanceof zzdn) {
            return (zzdn)iInterface;
        }
        return new zzdo(iBinder2);
    }
}

