/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.wearable.zze;
import com.google.android.gms.internal.wearable.zzf;
import com.google.android.gms.internal.wearable.zzg;
import com.google.android.gms.internal.wearable.zzs;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

@VisibleForTesting
public class DataMapItem {
    private final Uri uri;
    private final DataMap zzr;

    public static DataMapItem fromDataItem(@NonNull DataItem dataItem) {
        Asserts.checkNotNull((Object)dataItem, (Object)"dataItem must not be null");
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem dataItem) {
        this.uri = dataItem.getUri();
        this.zzr = DataMapItem.zza((DataItem)dataItem.freeze());
    }

    public Uri getUri() {
        return this.uri;
    }

    public DataMap getDataMap() {
        return this.zzr;
    }

    private static DataMap zza(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n = dataItem.getAssets().size();
            for (int i = 0; i < n; ++i) {
                DataItemAsset dataItemAsset = dataItem.getAssets().get(Integer.toString(i));
                if (dataItemAsset == null) {
                    int n2 = i;
                    String string = String.valueOf(dataItem);
                    throw new IllegalStateException(new StringBuilder(64 + String.valueOf(string).length()).append("Cannot find DataItemAsset referenced in data at ").append(n2).append(" for ").append(string).toString());
                }
                Asset asset = Asset.createFromRef(dataItemAsset.getId());
                arrayList.add(asset);
            }
            zzg zzg2 = zzg.zza(dataItem.getData());
            return zze.zza(new zzf(zzg2, arrayList));
        }
        catch (zzs | NullPointerException exception) {
            String string = String.valueOf(dataItem.getUri());
            String string2 = Base64.encodeToString((byte[])dataItem.getData(), (int)0);
            Log.w((String)"DataItem", (String)new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to parse datamap from dataItem. uri=").append(string).append(", data=").append(string2).toString());
            string = String.valueOf(dataItem.getUri());
            throw new IllegalStateException(new StringBuilder(44 + String.valueOf(string).length()).append("Unable to parse datamap from dataItem.  uri=").append(string).toString(), exception);
        }
    }
}

