/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzh;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="PutDataRequestCreator")
public class PutDataRequest
extends AbstractSafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzh();
    private static final long zzt = TimeUnit.MINUTES.toMillis(30L);
    private static final Random zzu = new SecureRandom();
    @SafeParcelable.Field(id=2, getter="getUri")
    private final Uri uri;
    @SafeParcelable.Field(id=4, getter="getAssetsInternal")
    private final Bundle zzv;
    @SafeParcelable.Field(id=5, getter="getData")
    private byte[] data;
    @SafeParcelable.Field(id=6, getter="getSyncDeadline")
    private long zzw;

    @SafeParcelable.Constructor
    PutDataRequest(@SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=4) Bundle bundle, @SafeParcelable.Param(id=5) byte[] byArray, @SafeParcelable.Param(id=6) long l) {
        this.uri = uri;
        this.zzv = bundle;
        this.zzv.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.data = byArray;
        this.zzw = l;
    }

    private PutDataRequest(Uri uri) {
        this(uri, new Bundle(), null, zzt);
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Asserts.checkNotNull((Object)parcel, (Object)"dest must not be null");
        Parcel parcel2 = parcel;
        PutDataRequest putDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)putDataRequest.getUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)putDataRequest.zzv, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)5, (byte[])putDataRequest.getData(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)putDataRequest.zzw);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static PutDataRequest createFromDataItem(@NonNull DataItem dataItem) {
        Asserts.checkNotNull((Object)dataItem, (Object)"source must not be null");
        PutDataRequest putDataRequest = PutDataRequest.zza(dataItem.getUri());
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                String string = String.valueOf(entry.getKey());
                throw new IllegalStateException(string.length() != 0 ? "Cannot create an asset for a put request without a digest: ".concat(string) : new String("Cannot create an asset for a put request without a digest: "));
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(dataItem.getData());
        return putDataRequest;
    }

    public static PutDataRequest zza(@NonNull Uri uri) {
        Asserts.checkNotNull((Object)uri, (Object)"uri must not be null");
        return new PutDataRequest(uri);
    }

    public static PutDataRequest createWithAutoAppendedId(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"pathPrefix must not be null");
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzu.nextLong());
        Uri uri = PutDataRequest.zza(stringBuilder.toString());
        return new PutDataRequest(uri);
    }

    public static PutDataRequest create(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"path must not be null");
        return PutDataRequest.zza(PutDataRequest.zza(string));
    }

    private static Uri zza(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.uri;
    }

    @VisibleForTesting
    public byte[] getData() {
        return this.data;
    }

    public PutDataRequest setData(byte[] byArray) {
        this.data = byArray;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzv.keySet()) {
            hashMap.put(string, (Asset)this.zzv.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @VisibleForTesting
    public Asset getAsset(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"key must not be null");
        return (Asset)this.zzv.getParcelable(string);
    }

    public boolean hasAsset(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"key must not be null");
        return this.zzv.containsKey(string);
    }

    public PutDataRequest putAsset(@NonNull String string, @NonNull Asset asset) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)((Object)asset));
        this.zzv.putParcelable(string, (Parcelable)asset);
        return this;
    }

    public PutDataRequest removeAsset(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"key must not be null");
        this.zzv.remove(string);
        return this;
    }

    public boolean isUrgent() {
        return this.zzw == 0L;
    }

    public PutDataRequest setUrgent() {
        this.zzw = 0L;
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        String string = String.valueOf(this.data == null ? "null" : Integer.valueOf(this.data.length));
        stringBuilder.append(new StringBuilder(7 + String.valueOf(string).length()).append("dataSz=").append(string).toString());
        int n = this.zzv.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        String string2 = String.valueOf(this.uri);
        stringBuilder.append(new StringBuilder(6 + String.valueOf(string2).length()).append(", uri=").append(string2).toString());
        long l = this.zzw;
        stringBuilder.append(new StringBuilder(35).append(", syncDeadline=").append(l).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        for (String string3 : this.zzv.keySet()) {
            String string4 = String.valueOf(this.zzv.getParcelable(string3));
            stringBuilder.append(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n    ").append(string3).append(": ").append(string4).toString());
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

