/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzay;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ChannelEventParcelableCreator")
public final class zzaw
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaw> CREATOR = new zzax();
    @SafeParcelable.Field(id=2)
    private final zzay zzck;
    @SafeParcelable.Field(id=3)
    private final int type;
    @SafeParcelable.Field(id=4)
    private final int zzg;
    @SafeParcelable.Field(id=5)
    private final int zzcj;

    @SafeParcelable.Constructor
    public zzaw(@SafeParcelable.Param(id=2) zzay zzay2, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3) {
        this.zzck = zzay2;
        this.type = n;
        this.zzg = n2;
        this.zzcj = n3;
    }

    public final void zza(ChannelApi.ChannelListener channelListener) {
        switch (this.type) {
            case 1: {
                channelListener.onChannelOpened(this.zzck);
                return;
            }
            case 2: {
                channelListener.onChannelClosed(this.zzck, this.zzg, this.zzcj);
                return;
            }
            case 3: {
                channelListener.onInputClosed(this.zzck, this.zzg, this.zzcj);
                return;
            }
            case 4: {
                channelListener.onOutputClosed(this.zzck, this.zzg, this.zzcj);
                return;
            }
        }
        int n = this.type;
        Log.w((String)"ChannelEventParcelable", (String)new StringBuilder(25).append("Unknown type: ").append(n).toString());
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzaw zzaw2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzaw2.zzck, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzaw2.type);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzaw2.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)zzaw2.zzcj);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        String string2;
        String string3 = String.valueOf(this.zzck);
        int n = this.type;
        switch (n) {
            case 1: {
                string2 = "CHANNEL_OPENED";
                break;
            }
            case 2: {
                string2 = "CHANNEL_CLOSED";
                break;
            }
            case 4: {
                string2 = "OUTPUT_CLOSED";
                break;
            }
            case 3: {
                string2 = "INPUT_CLOSED";
                break;
            }
            default: {
                string2 = Integer.toString(n);
            }
        }
        String string4 = string2;
        n = this.zzg;
        switch (n) {
            case 1: {
                string = "CLOSE_REASON_DISCONNECTED";
                break;
            }
            case 2: {
                string = "CLOSE_REASON_REMOTE_CLOSE";
                break;
            }
            case 3: {
                string = "CLOSE_REASON_LOCAL_CLOSE";
                break;
            }
            case 0: {
                string = "CLOSE_REASON_NORMAL";
                break;
            }
            default: {
                string = Integer.toString(n);
            }
        }
        String string5 = string;
        int n2 = this.zzcj;
        return new StringBuilder(81 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("ChannelEventParcelable[, channel=").append(string3).append(", type=").append(string4).append(", closeReason=").append(string5).append(", appErrorCode=").append(n2).append("]").toString();
    }
}

