/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.internal.zzde;
import java.util.HashMap;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="DataItemParcelableCreator")
public final class zzdd
extends AbstractSafeParcelable
implements DataItem {
    public static final Parcelable.Creator<zzdd> CREATOR = new zzde();
    @SafeParcelable.Field(id=2, getter="getUri")
    private final Uri uri;
    @SafeParcelable.Field(id=4, getter="getAssetsInternal", type="android.os.Bundle")
    private final Map<String, DataItemAsset> zzdo;
    @SafeParcelable.Field(id=5, getter="getData")
    private byte[] data;

    @SafeParcelable.Constructor
    zzdd(@SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=4) Bundle bundle, @SafeParcelable.Param(id=5) byte[] byArray) {
        this.uri = uri;
        HashMap<String, DataItemAsset> hashMap = new HashMap<String, DataItemAsset>();
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (String string : bundle.keySet()) {
            hashMap.put(string, (DataItemAssetParcelable)bundle.getParcelable(string));
        }
        this.zzdo = hashMap;
        this.data = byArray;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzdd zzdd2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzdd2.getUri(), (int)n, (boolean)false);
        zzdd zzdd3 = zzdd2;
        Bundle bundle = new Bundle();
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (Map.Entry<String, DataItemAsset> entry : zzdd3.zzdo.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)new DataItemAssetParcelable(entry.getValue()));
        }
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)bundle, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)5, (byte[])zzdd2.getData(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }

    @Override
    @VisibleForTesting
    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final Map<String, DataItemAsset> getAssets() {
        return this.zzdo;
    }

    public final String toString() {
        boolean bl = Log.isLoggable((String)"DataItem", (int)3);
        zzdd zzdd2 = this;
        StringBuilder stringBuilder = new StringBuilder("DataItemParcelable[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(zzdd2.hashCode()));
        String string = String.valueOf(zzdd2.data == null ? "null" : Integer.valueOf(zzdd2.data.length));
        stringBuilder.append(new StringBuilder(8 + String.valueOf(string).length()).append(",dataSz=").append(string).toString());
        int n = zzdd2.zzdo.size();
        stringBuilder.append(new StringBuilder(23).append(", numAssets=").append(n).toString());
        String string2 = String.valueOf(zzdd2.uri);
        stringBuilder.append(new StringBuilder(6 + String.valueOf(string2).length()).append(", uri=").append(string2).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        for (String string3 : zzdd2.zzdo.keySet()) {
            String string4 = String.valueOf(zzdd2.zzdo.get(string3));
            stringBuilder.append(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n    ").append(string3).append(": ").append(string4).toString());
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }

    @Override
    public final /* synthetic */ DataItem setData(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzdd zzdd2 = this;
        this.data = byArray2;
        return zzdd2;
    }
}

