/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.Preconditions;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageClient;
import com.google.android.gms.wearable.internal.zzeu;
import com.google.android.gms.wearable.internal.zzfa;
import com.google.android.gms.wearable.internal.zzfc;
import com.google.android.gms.wearable.internal.zzfd;
import com.google.android.gms.wearable.internal.zzgj;

public final class zzez
extends MessageClient {
    @VisibleForTesting
    private final MessageApi zzei = new zzeu();

    public zzez(@NonNull Context context, @NonNull GoogleApi.Settings settings) {
        super(context, settings);
    }

    public zzez(@NonNull Activity activity, @NonNull GoogleApi.Settings settings) {
        super(activity, settings);
    }

    @Override
    public final Task<Integer> sendMessage(String string, String string2, byte[] byArray) {
        return PendingResultUtil.toTask(this.zzei.sendMessage(this.asGoogleApiClient(), string, string2, byArray), (PendingResultUtil.ResultConverter)zzfa.zzbx);
    }

    @Override
    public final Task<Void> addListener(MessageClient.OnMessageReceivedListener onMessageReceivedListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgj.zzc("com.google.android.gms.wearable.MESSAGE_RECEIVED")};
        return this.zza(onMessageReceivedListener, intentFilterArray);
    }

    @Override
    public final Task<Void> addListener(MessageClient.OnMessageReceivedListener onMessageReceivedListener, Uri uri, int n) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        com.google.android.gms.common.internal.Preconditions.checkArgument((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzgj.zza("com.google.android.gms.wearable.MESSAGE_RECEIVED", uri, n);
        return this.zza(onMessageReceivedListener, new IntentFilter[]{intentFilter});
    }

    private final Task<Void> zza(MessageClient.OnMessageReceivedListener onMessageReceivedListener, IntentFilter[] intentFilterArray) {
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onMessageReceivedListener, (Looper)this.getLooper(), (String)"MessageListener");
        zzfc zzfc2 = new zzfc(onMessageReceivedListener, intentFilterArray, listenerHolder, null);
        zzfd zzfd2 = new zzfd(onMessageReceivedListener, listenerHolder.getListenerKey(), null);
        return this.doRegisterEventListener(zzfc2, zzfd2);
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull MessageClient.OnMessageReceivedListener onMessageReceivedListener) {
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onMessageReceivedListener, (Looper)this.getLooper(), (String)"MessageListener");
        return this.doUnregisterEventListener(listenerHolder.getListenerKey());
    }
}

