/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.wearable.zzc;

public class Asset
implements SafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zzc();
    final int zzzH;
    private byte[] zzanX;
    private String zzaKy;
    public ParcelFileDescriptor zzaKz;
    public Uri uri;

    Asset(int versionCode, byte[] data, String digest, ParcelFileDescriptor fd, Uri uri) {
        this.zzzH = versionCode;
        this.zzanX = data;
        this.zzaKy = digest;
        this.zzaKz = fd;
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags | 1);
    }

    public static Asset createFromRef(String digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, digest, null, null);
    }

    public static Asset createFromBytes(byte[] assetData) {
        if (assetData == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, assetData, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, fd, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.zzanX;
    }

    public String getDigest() {
        return this.zzaKy;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzaKz;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzanX, this.zzaKy, this.zzaKz, this.uri});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o;
        return zzu.equal((Object)this.zzanX, (Object)asset.zzanX) && zzu.equal((Object)this.zzaKy, (Object)asset.zzaKy) && zzu.equal((Object)this.zzaKz, (Object)asset.zzaKz) && zzu.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzaKy == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzaKy);
        }
        if (this.zzanX != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzanX.length);
        }
        if (this.zzaKz != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzaKz);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

