/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzas;
import com.google.android.gms.wearable.zzh;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener,
NodeApi.zza {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private volatile int zzSR = -1;
    private String zzJd;
    private Handler zzaKO;
    private IBinder zzSU;
    private Object zzaKP = new Object();
    private boolean zzFF;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onCreate: " + this.getPackageName()));
        }
        this.zzJd = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.zzaKO = new Handler(handlerThread.getLooper());
        this.zzSU = new zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.zzaKP;
        synchronized (object) {
            this.zzFF = true;
            if (this.zzaKO == null) {
                throw new IllegalStateException("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()?");
            }
            this.zzaKO.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzSU;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node peer) {
    }

    @Override
    public void onPeerDisconnected(Node peer) {
    }

    @Override
    public void onConnectedNodes(List<Node> connectedNodes) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onInputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onOutputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    private void zzyY() throws SecurityException {
        int n = Binder.getCallingUid();
        if (n == this.zzSR) {
            return;
        }
        if (GooglePlayServicesUtil.zzd((Context)this, (int)n)) {
            this.zzSR = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    private class zza
    extends zzas.zza {
        boolean zzaKQ = false;

        zza() {
            this.zzaKQ = WearableListenerService.this instanceof zzh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzac(final DataHolder dataHolder) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onDataItemChanged: " + WearableListenerService.this.zzJd + ": " + dataHolder));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    dataHolder.close();
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                        try {
                            WearableListenerService.this.onDataChanged(dataEventBuffer);
                        }
                        finally {
                            dataEventBuffer.release();
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onMessageReceived: " + messageEventParcelable));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onMessageReceived(messageEventParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerConnected: " + WearableListenerService.this.zzJd + ": " + nodeParcelable));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onPeerConnected(nodeParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerDisconnected: " + WearableListenerService.this.zzJd + ": " + nodeParcelable));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectedNodes(final List<NodeParcelable> connectedNodes) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onConnectedNodes: " + WearableListenerService.this.zzJd + ": " + connectedNodes));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onConnectedNodes(connectedNodes);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onConnectedCapabilityChanged: " + capabilityInfoParcelable));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onNotificationReceived: " + ancsNotificationParcelable));
            }
            if (!this.zzaKQ) {
                return;
            }
            WearableListenerService.this.zzyY();
            final zzh zzh2 = (zzh)WearableListenerService.this;
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        zzh2.zza(ancsNotificationParcelable);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onChannelEvent: " + channelEventParcelable));
            }
            WearableListenerService.this.zzyY();
            Object object = WearableListenerService.this.zzaKP;
            synchronized (object) {
                if (WearableListenerService.this.zzFF) {
                    return;
                }
                WearableListenerService.this.zzaKO.post(new Runnable(){

                    @Override
                    public void run() {
                        channelEventParcelable.zza(WearableListenerService.this);
                    }
                });
            }
        }
    }
}

