/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.ChannelImpl;
import com.google.android.gms.wearable.internal.zzk;

public final class ChannelEventParcelable
implements SafeParcelable {
    public static final Parcelable.Creator<ChannelEventParcelable> CREATOR = new zzk();
    final int zzzH;
    final ChannelImpl zzaLB;
    final int type;
    final int zzaLz;
    final int zzaLA;

    ChannelEventParcelable(int versionCode, ChannelImpl channel, int type, int closeReason, int appErrorCode) {
        this.zzzH = versionCode;
        this.zzaLB = channel;
        this.type = type;
        this.zzaLz = closeReason;
        this.zzaLA = appErrorCode;
    }

    public void zza(ChannelApi.ChannelListener channelListener) {
        switch (this.type) {
            case 1: {
                channelListener.onChannelOpened(this.zzaLB);
                break;
            }
            case 2: {
                channelListener.onChannelClosed(this.zzaLB, this.zzaLz, this.zzaLA);
                break;
            }
            case 3: {
                channelListener.onInputClosed(this.zzaLB, this.zzaLz, this.zzaLA);
                break;
            }
            case 4: {
                channelListener.onOutputClosed(this.zzaLB, this.zzaLz, this.zzaLA);
                break;
            }
            default: {
                Log.w((String)"ChannelEventParcelable", (String)("Unknown type: " + this.type));
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzk.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelEventParcelable[versionCode=" + this.zzzH + ", channel=" + this.zzaLB + ", type=" + ChannelEventParcelable.zziE(this.type) + ", closeReason=" + ChannelEventParcelable.zziF(this.zzaLz) + ", appErrorCode=" + this.zzaLA + "]";
    }

    private static String zziE(int n) {
        switch (n) {
            case 1: {
                return "CHANNEL_OPENED";
            }
            case 2: {
                return "CHANNEL_CLOSED";
            }
            case 4: {
                return "OUTPUT_CLOSED";
            }
            case 3: {
                return "INPUT_CLOSED";
            }
        }
        return Integer.toString(n);
    }

    private static String zziF(int n) {
        switch (n) {
            case 1: {
                return "CLOSE_REASON_DISCONNECTED";
            }
            case 2: {
                return "CLOSE_REASON_REMOTE_CLOSE";
            }
            case 3: {
                return "CLOSE_REASON_LOCAL_CLOSE";
            }
            case 0: {
                return "CLOSE_REASON_NORMAL";
            }
        }
        return Integer.toString(n);
    }
}

