/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.wearable.zze;

public class Asset
implements SafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    final int mVersionCode;
    private byte[] zzayG;
    private String zzaYK;
    public ParcelFileDescriptor zzaYL;
    public Uri uri;

    Asset(int versionCode, byte[] data, String digest, ParcelFileDescriptor fd, Uri uri) {
        this.mVersionCode = versionCode;
        this.zzayG = data;
        this.zzaYK = digest;
        this.zzaYL = fd;
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    public static Asset createFromRef(String digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, digest, null, null);
    }

    public static Asset createFromBytes(byte[] assetData) {
        if (assetData == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, assetData, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, fd, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.zzayG;
    }

    public String getDigest() {
        return this.zzaYK;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzaYL;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzayG, this.zzaYK, this.zzaYL, this.uri});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o;
        return zzw.equal((Object)this.zzayG, (Object)asset.zzayG) && zzw.equal((Object)this.zzaYK, (Object)asset.zzaYK) && zzw.equal((Object)this.zzaYL, (Object)asset.zzaYL) && zzw.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzaYK == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzaYK);
        }
        if (this.zzayG != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzayG.length);
        }
        if (this.zzaYL != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzaYL);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

