/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzh;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzh();
    private static final Random zzbfd = new SecureRandom();
    final int mVersionCode;
    private final Uri mUri;
    private final Bundle zzbfe;
    private byte[] zzaBg;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.mVersionCode = versionCode;
        this.mUri = uri;
        this.zzbfe = assets;
        this.zzbfe.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zzaBg = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzh.zza(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.zzo(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest zzo(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzbfd.nextLong());
        Uri uri = PutDataRequest.zzfw(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.zzfw(path);
        return PutDataRequest.zzo(uri);
    }

    private static Uri zzfw(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.zzaBg;
    }

    public PutDataRequest setData(byte[] data) {
        this.zzaBg = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzbfe.keySet()) {
            hashMap.put(string, (Asset)this.zzbfe.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle zzEM() {
        return this.zzbfe;
    }

    public Asset getAsset(String key) {
        return (Asset)this.zzbfe.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.zzbfe.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        zzx.zzw((Object)key);
        zzx.zzw((Object)value);
        this.zzbfe.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.zzbfe.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.zzaBg == null ? "null" : Integer.valueOf(this.zzaBg.length)));
        stringBuilder.append(", numAssets=" + this.zzbfe.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.zzbfe.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzbfe.getParcelable(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

