/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzsy;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzblV;
    private final DataMap zzblU;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzblV = putDataRequest;
        this.zzblU = new DataMap();
        if (dataMap != null) {
            this.zzblU.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.zzr(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.zzblV.getUri();
    }

    public DataMap getDataMap() {
        return this.zzblU;
    }

    public PutDataMapRequest setUrgent() {
        this.zzblV.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzblV.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzsy.zza zza2 = zzsy.zza(this.zzblU);
        this.zzblV.setData(zztk.toByteArray((zztk)zza2.zzbpf));
        int n = zza2.zzbpg.size();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toString(i);
            Asset asset = zza2.zzbpg.get(i);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.zzblV.putAsset(string, asset);
        }
        return this.zzblV;
    }
}

