/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzi;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new zzi();
    private static final long zzblW = TimeUnit.MINUTES.toMillis(30L);
    private static final Random zzblX = new SecureRandom();
    final int mVersionCode;
    private final Uri mUri;
    private final Bundle zzblY;
    private byte[] zzaHC;
    private long zzblZ;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data, long syncDeadline) {
        this.mVersionCode = versionCode;
        this.mUri = uri;
        this.zzblY = assets;
        this.zzblY.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.zzaHC = data;
        this.zzblZ = syncDeadline;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null, zzblW);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzi.zza(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.zzr(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest zzr(Uri uri) {
        return new PutDataRequest(2, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(zzblX.nextLong());
        Uri uri = PutDataRequest.zzfX(stringBuilder.toString());
        return new PutDataRequest(2, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.zzfX(path);
        return PutDataRequest.zzr(uri);
    }

    private static Uri zzfX(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.zzaHC;
    }

    public PutDataRequest setData(byte[] data) {
        this.zzaHC = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzblY.keySet()) {
            hashMap.put(string, (Asset)this.zzblY.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle zzGy() {
        return this.zzblY;
    }

    public Asset getAsset(String key) {
        return (Asset)this.zzblY.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.zzblY.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        zzx.zzy((Object)key);
        zzx.zzy((Object)value);
        this.zzblY.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.zzblY.remove(key);
        return this;
    }

    public long zzGz() {
        return this.zzblZ;
    }

    public boolean isUrgent() {
        return this.zzblZ == 0L;
    }

    public PutDataRequest setUrgent() {
        this.zzblZ = 0L;
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.zzaHC == null ? "null" : Integer.valueOf(this.zzaHC.length)));
        stringBuilder.append(", numAssets=" + this.zzblY.size());
        stringBuilder.append(", uri=" + this.mUri);
        stringBuilder.append(", syncDeadline=" + this.zzblZ);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.zzblY.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzblY.getParcelable(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

