/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AmsEntityUpdateParcelable;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.LargeAssetQueueStateChangeParcelable;
import com.google.android.gms.wearable.internal.LargeAssetSyncRequestPayload;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzay;
import com.google.android.gms.wearable.internal.zzba;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.zzk;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener,
NodeApi.zza {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private String zzSp;
    private Handler zzbmg;
    private IBinder zzaiT;
    private final Object zzbmh = new Object();
    private boolean zzOR;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onCreate: " + this.getPackageName()));
        }
        this.zzSp = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.zzbmg = new Handler(handlerThread.getLooper());
        this.zzaiT = new zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.zzbmh;
        synchronized (object) {
            this.zzOR = true;
            if (this.zzbmg == null) {
                throw new IllegalStateException("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()?");
            }
            this.zzbmg.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzaiT;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node peer) {
    }

    @Override
    public void onPeerDisconnected(Node peer) {
    }

    @Override
    public void onConnectedNodes(List<Node> connectedNodes) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onInputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    @Override
    public void onOutputClosed(Channel channel, int closeReason, int appSpecificErrorCode) {
    }

    private final class zza
    extends zzba.zza {
        private volatile int zzaiR = -1;

        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzag(final DataHolder dataHolder) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(dataEventBuffer);
                    }
                    finally {
                        dataEventBuffer.release();
                    }
                }
            };
            boolean bl = false;
            try {
                bl = this.zzb(runnable, "onDataItemChanged", dataHolder);
            }
            finally {
                if (!bl) {
                    dataHolder.close();
                }
            }
        }

        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(messageEventParcelable);
                }
            };
            this.zzb(runnable, "onMessageReceived", messageEventParcelable);
        }

        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(nodeParcelable);
                }
            };
            this.zzb(runnable, "onPeerConnected", nodeParcelable);
        }

        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                }
            };
            this.zzb(runnable, "onPeerDisconnected", nodeParcelable);
        }

        @Override
        public void onConnectedNodes(final List<NodeParcelable> connectedNodes) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onConnectedNodes(connectedNodes);
                }
            };
            this.zzb(runnable, "onConnectedNodes", connectedNodes);
        }

        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                }
            };
            this.zzb(runnable, "onConnectedCapabilityChanged", capabilityInfoParcelable);
        }

        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzk zzk2 = (zzk)WearableListenerService.this;
                    zzk2.zza(ancsNotificationParcelable);
                }
            };
            this.zza(runnable, "onNotificationReceived", ancsNotificationParcelable);
        }

        @Override
        public void zza(final AmsEntityUpdateParcelable amsEntityUpdateParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzk zzk2 = (zzk)WearableListenerService.this;
                    zzk2.zza(amsEntityUpdateParcelable);
                }
            };
            this.zza(runnable, "onEntityUpdate", amsEntityUpdateParcelable);
        }

        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channelEventParcelable.zza(WearableListenerService.this);
                }
            };
            this.zzb(runnable, "onChannelEvent", channelEventParcelable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(final LargeAssetQueueStateChangeParcelable largeAssetQueueStateChangeParcelable) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        zzk zzk2 = (zzk)WearableListenerService.this;
                        zzk2.zza(largeAssetQueueStateChangeParcelable);
                    }
                    finally {
                        largeAssetQueueStateChangeParcelable.release();
                    }
                }
            };
            boolean bl = false;
            try {
                bl = this.zza(runnable, "onLargeAssetStateChanged", largeAssetQueueStateChangeParcelable);
            }
            finally {
                if (!bl) {
                    largeAssetQueueStateChangeParcelable.release();
                }
            }
        }

        @Override
        public void zza(final LargeAssetSyncRequestPayload largeAssetSyncRequestPayload, final zzay zzay2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzbj zzbj2 = new zzbj(largeAssetSyncRequestPayload, zzay2);
                    zzk zzk2 = (zzk)WearableListenerService.this;
                    zzk2.zza(zzbj2);
                    try {
                        zzbj2.zzGX();
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)"WearableLS", (String)"Failed to respond to LargeAssetRequest", (Throwable)remoteException);
                    }
                }
            };
            this.zza(runnable, "onLargeAssetSyncRequest", largeAssetSyncRequestPayload);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(zzax zzax2, String string, int n) {
            boolean bl = WearableListenerService.this instanceof zzk;
            if (!bl) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("openFileDescriptor: %s (mode=%s)", string, n));
            }
            this.zzGA();
            Object object = WearableListenerService.this.zzbmh;
            synchronized (object) {
                if (WearableListenerService.this.zzOR) {
                    return;
                }
            }
            object = null;
            try {
                File file = new File(string);
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    Log.w((String)"WearableLS", (String)("Unable to create directory: " + file2.getAbsolutePath()));
                    zzax2.zzb(null);
                    return;
                }
                try {
                    object = ParcelFileDescriptor.open((File)new File(string), (int)(n | 0x8000000));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableLS", (String)("Failed to open file: " + string), (Throwable)fileNotFoundException);
                    zzax2.zzb(null);
                    zznt.zza((ParcelFileDescriptor)object);
                    return;
                }
                zzax2.zzb((ParcelFileDescriptor)object);
            }
            catch (RemoteException remoteException) {
                Log.w((String)"WearableLS", (String)"Failed to set file descriptor", (Throwable)remoteException);
            }
            finally {
                zznt.zza((ParcelFileDescriptor)object);
            }
        }

        private boolean zza(Runnable runnable, String string, Object object) {
            boolean bl = WearableListenerService.this instanceof zzk;
            if (!bl) {
                return false;
            }
            return this.zzb(runnable, string, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zzb(Runnable runnable, String string, Object object) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzSp, object));
            }
            this.zzGA();
            Object object2 = WearableListenerService.this.zzbmh;
            synchronized (object2) {
                if (WearableListenerService.this.zzOR) {
                    return false;
                }
                WearableListenerService.this.zzbmg.post(runnable);
            }
            return true;
        }

        private void zzGA() throws SecurityException {
            int n = Binder.getCallingUid();
            if (n == this.zzaiR) {
                return;
            }
            if (GooglePlayServicesUtil.zze((Context)WearableListenerService.this, (int)n)) {
                this.zzaiR = n;
                return;
            }
            throw new SecurityException("Caller is not GooglePlayServices");
        }
    }
}

