/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzcc;
import com.google.android.gms.wearable.internal.zzce;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.internal.zzo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzo();
    final int mVersionCode;
    private final String zzTR;
    private final String zzblS;
    private final String mPath;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.mVersionCode = versionCode;
        this.zzTR = (String)zzx.zzy((Object)token);
        this.zzblS = (String)zzx.zzy((Object)nodeId);
        this.mPath = (String)zzx.zzy((Object)path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzo.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.mVersionCode + ", token='" + this.zzTR + '\'' + ", nodeId='" + this.zzblS + '\'' + ", path='" + this.mPath + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzTR.equals(channelImpl.zzTR) && zzw.equal((Object)channelImpl.zzblS, (Object)this.zzblS) && zzw.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.zzTR.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzblS;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.zzTR;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zza((zzlx.zza)new zzi<Status>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzt((zzlx.zzb<Status>)this, ChannelImpl.this.zzTR);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zza((zzlx.zza)new zzi<Status>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzh((zzlx.zzb<Status>)this, ChannelImpl.this.zzTR, errorCode);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zza((zzlx.zza)new zzi<Channel.GetInputStreamResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzu((zzlx.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzTR);
            }

            public Channel.GetInputStreamResult zzbp(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbp(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zza((zzlx.zza)new zzi<Channel.GetOutputStreamResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzv((zzlx.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzTR);
            }

            public Channel.GetOutputStreamResult zzbq(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbq(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        return client.zza((zzlx.zza)new zzi<Status>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<Status>)this, ChannelImpl.this.zzTR, uri, append);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)this.zzTR, (Object)"token is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        zzx.zzb((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{startOffset});
        zzx.zzb((length >= 0L || length == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{length});
        return client.zza((zzlx.zza)new zzi<Status>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<Status>)this, ChannelImpl.this.zzTR, uri, startOffset, length);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzcc.zzfY("com.google.android.gms.wearable.CHANNEL_EVENT")};
        return com.google.android.gms.wearable.internal.zzb.zza(client, ChannelImpl.zza(this.zzTR, intentFilterArray), listener);
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zzlx.zza)new zzl.zzb(client, listener, this.zzTR));
    }

    private static zzb.zza<ChannelApi.ChannelListener> zza(final String string, final IntentFilter[] intentFilterArray) {
        return new zzb.zza<ChannelApi.ChannelListener>(){

            @Override
            public void zza(zzce zzce2, zzlx.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzmn<ChannelApi.ChannelListener> zzmn2) throws RemoteException {
                zzce2.zza(zzb2, channelListener, zzmn2, string, intentFilterArray);
            }
        };
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzTA;
        private final OutputStream zzbnd;

        zzb(Status status, OutputStream outputStream) {
            this.zzTA = (Status)zzx.zzy((Object)status);
            this.zzbnd = outputStream;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzbnd;
        }

        public void release() {
            if (this.zzbnd != null) {
                try {
                    this.zzbnd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzTA;
        private final InputStream zzbnc;

        zza(Status status, InputStream inputStream) {
            this.zzTA = (Status)zzx.zzy((Object)status);
            this.zzbnc = inputStream;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzbnc;
        }

        public void release() {
            if (this.zzbnc != null) {
                try {
                    this.zzbnc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

