/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.LargeAssetApi;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.PutDataResponse;
import com.google.android.gms.wearable.internal.zzaz;
import com.google.android.gms.wearable.internal.zzbb;
import com.google.android.gms.wearable.internal.zzbl;
import com.google.android.gms.wearable.internal.zzby;
import com.google.android.gms.wearable.internal.zzcd;
import com.google.android.gms.wearable.internal.zzcf;
import com.google.android.gms.wearable.internal.zzt;
import com.google.android.gms.wearable.zza;
import com.google.android.gms.wearable.zzc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzce
extends zzj<zzbb> {
    private final ExecutorService zzbfg = Executors.newCachedThreadPool();
    private final zzbl<zzc.zza> zzboJ = new zzbl();
    private final zzbl<zza.zza> zzboK = new zzbl();
    private final zzbl<ChannelApi.ChannelListener> zzboL = new zzbl();
    private final zzbl<LargeAssetApi.zza> zzboM = new zzbl();
    private final zzbl<DataApi.DataListener> zzboN = new zzbl();
    private final zzbl<MessageApi.MessageListener> zzboO = new zzbl();
    private final zzbl<NodeApi.NodeListener> zzboP = new zzbl();
    private final zzbl<NodeApi.zza> zzboQ = new zzbl();
    private final zzbl<CapabilityApi.CapabilityListener> zzboR = new zzbl();

    public zzce(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzf zzf2) {
        super(context, looper, 14, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    protected String zzgh() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String zzgi() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzbb zzet(IBinder iBinder) {
        return zzbb.zza.zzer(iBinder);
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n));
        }
        if (n == 0) {
            this.zzboJ.zzes(iBinder);
            this.zzboK.zzes(iBinder);
            this.zzboL.zzes(iBinder);
            this.zzboM.zzes(iBinder);
            this.zzboN.zzes(iBinder);
            this.zzboO.zzes(iBinder);
            this.zzboP.zzes(iBinder);
            this.zzboQ.zzes(iBinder);
            this.zzboR.zzes(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void disconnect() {
        this.zzboJ.zzb(this);
        this.zzboK.zzb(this);
        this.zzboL.zzb(this);
        this.zzboM.zzb(this);
        this.zzboN.zzb(this);
        this.zzboO.zzb(this);
        this.zzboP.zzb(this);
        this.zzboQ.zzb(this);
        this.zzboR.zzb(this);
        super.disconnect();
    }

    public void zza(zzlx.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzr(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            putDataRequest2.setUrgent();
        }
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            Object object;
            ParcelFileDescriptor parcelFileDescriptor;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() != null) {
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptor[0] + " write:" + parcelFileDescriptor[1]));
                }
                putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptor[0]));
                object = this.zza(parcelFileDescriptor[1], asset.getData());
                entry22.add(object);
                this.zzbfg.submit((Runnable)object);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r");
                    object = Asset.createFromFd(parcelFileDescriptor);
                    putDataRequest2.putAsset((String)entry3.getKey(), (Asset)object);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzcd.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)).zza(new PutDataResponse(4005, null));
                    Log.w((String)"WearableClient", (String)("Couldn't resolve asset URI: " + asset.getUri()));
                    return;
                }
            }
            putDataRequest2.putAsset((String)entry3.getKey(), asset);
        }
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzGY() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzGY();
            }
        });
    }

    public void zza(zzlx.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzk(zzb2), uri);
    }

    public void zzo(zzlx.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzbb)this.zzqs()).zzb(new zzcd.zzl(zzb2));
    }

    public void zza(zzlx.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzl(zzb2), uri, n);
    }

    public void zzb(zzlx.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzbb)this.zzqs()).zzb((zzaz)new zzcd.zze(zzb2), uri, n);
    }

    public void zza(zzlx.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzbb)this.zzqs()).zza(new zzcd.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zzlx.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzm(zzb2), asset);
    }

    public void zza(zzlx.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzp(zzlx.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzbb)this.zzqs()).zzc(new zzcd.zzn(zzb2));
    }

    public void zzq(zzlx.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzbb)this.zzqs()).zzd(new zzcd.zzj(zzb2));
    }

    public void zzg(zzlx.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzg(zzb2), string, n);
    }

    public void zzb(zzlx.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzf(zzb2), n);
    }

    public void zzr(zzlx.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzbb)this.zzqs()).zzd(new zzcd.zza(zzb2), string);
    }

    public void zzs(zzlx.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzbb)this.zzqs()).zze(new zzcd.zzs(zzb2), string);
    }

    public void zze(zzlx.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzp(zzb2), string, string2);
    }

    public void zzt(zzlx.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzbb)this.zzqs()).zzf(new zzcd.zzc(zzb2), string);
    }

    public void zzh(zzlx.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzbb)this.zzqs()).zzb((zzaz)new zzcd.zzd(zzb2), string, n);
    }

    public void zzu(zzlx.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzbb)this.zzqs()).zza((zzaz)new zzcd.zzh(zzb2, zzt2), zzt2, string);
    }

    public void zzv(zzlx.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzbb)this.zzqs()).zzb((zzaz)new zzcd.zzi(zzb2, zzt2), zzt2, string);
    }

    public void zza(zzlx.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            this.zzbfg.execute(this.zzb(zzb2, string, uri, bl));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzlx.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            this.zzbfg.execute(this.zzb(zzb2, string, uri, l, l2));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzx(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzlx.zzb<Status> zzb2, DataApi.DataListener dataListener, zzmn<DataApi.DataListener> zzmn2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzboN.zza(this, zzb2, dataListener, zzcf.zza(zzmn2, intentFilterArray));
    }

    public void zza(zzlx.zzb<Status> zzb2, MessageApi.MessageListener messageListener, zzmn<MessageApi.MessageListener> zzmn2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzboO.zza(this, zzb2, messageListener, zzcf.zzb(zzmn2, intentFilterArray));
    }

    public void zza(zzlx.zzb<Status> zzb2, NodeApi.NodeListener nodeListener, zzmn<NodeApi.NodeListener> zzmn2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzboP.zza(this, zzb2, nodeListener, zzcf.zzc(zzmn2, intentFilterArray));
    }

    public void zza(zzlx.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, zzmn<CapabilityApi.CapabilityListener> zzmn2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzboR.zza(this, zzb2, capabilityListener, zzcf.zze(zzmn2, intentFilterArray));
    }

    public void zza(zzlx.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzmn<ChannelApi.ChannelListener> zzmn2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzboL.zza(this, zzb2, channelListener, zzcf.zzd(zzmn2, intentFilterArray));
        } else {
            zzby zzby2 = new zzby(string, channelListener);
            this.zzboL.zza(this, zzb2, zzby2, zzcf.zza(zzmn2, string, intentFilterArray));
        }
    }

    public void zza(zzlx.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzboN.zza(this, zzb2, dataListener);
    }

    public void zza(zzlx.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzboO.zza(this, zzb2, messageListener);
    }

    public void zza(zzlx.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzboP.zza(this, zzb2, nodeListener);
    }

    public void zza(zzlx.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzboR.zza(this, zzb2, capabilityListener);
    }

    public void zza(zzlx.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzboL.zza(this, zzb2, channelListener);
        } else {
            zzby zzby2 = new zzby(string, channelListener);
            this.zzboL.zza(this, zzb2, zzby2);
        }
    }

    private Runnable zzb(final zzlx.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        zzx.zzy(zzb2);
        zzx.zzy((Object)string);
        zzx.zzy((Object)uri);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.receiveFile: " + file));
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzbb)zzce.this.zzqs()).zza((zzaz)new zzcd.zzu((zzlx.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    private Runnable zzb(final zzlx.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        zzx.zzy(zzb2);
        zzx.zzy((Object)string);
        zzx.zzy((Object)uri);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzx.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzx(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.sendFile: " + file));
                    zzb2.zzx(new Status(13));
                    return;
                }
                try {
                    ((zzbb)zzce.this.zzqs()).zza(new zzcd.zzr((zzlx.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzx(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzet(iBinder);
    }
}

