/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzcc;
import com.google.android.gms.wearable.internal.zzce;
import com.google.android.gms.wearable.internal.zzi;
import java.io.IOException;
import java.io.InputStream;

public final class zzx
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient client, final PutDataRequest request) {
        return client.zza((zzlx.zza)new zzi<DataApi.DataItemResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<DataApi.DataItemResult>)this, request);
            }

            public DataApi.DataItemResult zzbr(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbr(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient client, final Uri uri) {
        return client.zza((zzlx.zza)new zzi<DataApi.DataItemResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbr(Status status) {
                return new zza(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbr(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client) {
        return client.zza((zzlx.zza)new zzi<DataItemBuffer>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzo((zzlx.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzbs(Status status) {
                return new DataItemBuffer(DataHolder.zzbJ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbs(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, Uri uri) {
        return this.getDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        com.google.android.gms.common.internal.zzx.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        com.google.android.gms.common.internal.zzx.zzb((filterType == 0 || filterType == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return client.zza((zzlx.zza)new zzi<DataItemBuffer>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<DataItemBuffer>)this, uri, filterType);
            }

            protected DataItemBuffer zzbs(Status status) {
                return new DataItemBuffer(DataHolder.zzbJ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbs(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, Uri uri) {
        return this.deleteDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        com.google.android.gms.common.internal.zzx.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        com.google.android.gms.common.internal.zzx.zzb((filterType == 0 || filterType == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return client.zza((zzlx.zza)new zzi<DataApi.DeleteDataItemsResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zzb((zzlx.zzb<DataApi.DeleteDataItemsResult>)this, uri, filterType);
            }

            protected DataApi.DeleteDataItemsResult zzbt(Status status) {
                return new zzb(status, 0);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbt(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final Asset asset) {
        this.zza(asset);
        return client.zza((zzlx.zza)new zzi<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbu(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbu(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final DataItemAsset asset) {
        return client.zza((zzlx.zza)new zzi<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbu(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbu(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, DataApi.DataListener listener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzcc.zzfY("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(client, listener, intentFilterArray);
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, DataApi.DataListener listener, Uri uri, int filterType) {
        com.google.android.gms.common.internal.zzx.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        com.google.android.gms.common.internal.zzx.zzb((filterType == 0 || filterType == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzcc.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, filterType);
        return this.zza(client, listener, new IntentFilter[]{intentFilter});
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzx.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzce zzce2, zzlx.zzb<Status> zzb2, DataApi.DataListener dataListener, zzmn<DataApi.DataListener> zzmn2) throws RemoteException {
                zzce2.zza(zzb2, dataListener, zzmn2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, final DataApi.DataListener listener) {
        return client.zza((zzlx.zza)new zzi<Status>(client){

            protected void zza(zzce zzce2) throws RemoteException {
                zzce2.zza((zzlx.zzb<Status>)this, listener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status zzTA;
        private volatile ParcelFileDescriptor zzbns;
        private volatile InputStream zzbnc;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzTA = status;
            this.zzbns = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbns;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbns == null) {
                return null;
            }
            if (this.zzbnc == null) {
                this.zzbnc = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbns);
            }
            return this.zzbnc;
        }

        public void release() {
            if (this.zzbns == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzbnc != null) {
                    this.zzbnc.close();
                } else {
                    this.zzbns.close();
                }
                this.mClosed = true;
                this.zzbns = null;
                this.zzbnc = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status zzTA;
        private final int zzbnr;

        public zzb(Status status, int n) {
            this.zzTA = status;
            this.zzbnr = n;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public int getNumDeleted() {
            return this.zzbnr;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status zzTA;
        private final DataItem zzbnq;

        public zza(Status status, DataItem dataItem) {
            this.zzTA = status;
            this.zzbnq = dataItem;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbnq;
        }
    }
}

