/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.PutDataResponse;
import com.google.android.gms.wearable.internal.zzav;
import com.google.android.gms.wearable.internal.zzax;
import com.google.android.gms.wearable.internal.zzay;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.internal.zzbo;
import com.google.android.gms.wearable.internal.zzbq;
import com.google.android.gms.wearable.internal.zzt;
import com.google.android.gms.wearable.zza;
import com.google.android.gms.wearable.zzc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzbp
extends zzj<zzax> {
    private final ExecutorService zzbkn = Executors.newCachedThreadPool();
    private final zzay<zzc.zza> zzbte = new zzay();
    private final zzay<zza.zza> zzbtf = new zzay();
    private final zzay<ChannelApi.ChannelListener> zzbtg = new zzay();
    private final zzay<DataApi.DataListener> zzbth = new zzay();
    private final zzay<MessageApi.MessageListener> zzbti = new zzay();
    private final zzay<NodeApi.NodeListener> zzbtj = new zzay();
    private final zzay<NodeApi.zza> zzbtk = new zzay();
    private final zzay<CapabilityApi.CapabilityListener> zzbtl = new zzay();

    public zzbp(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzf zzf2) {
        super(context, looper, 14, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    protected String zzgu() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String zzgv() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzax zzew(IBinder iBinder) {
        return zzax.zza.zzeu(iBinder);
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n));
        }
        if (n == 0) {
            this.zzbte.zzev(iBinder);
            this.zzbtf.zzev(iBinder);
            this.zzbtg.zzev(iBinder);
            this.zzbth.zzev(iBinder);
            this.zzbti.zzev(iBinder);
            this.zzbtj.zzev(iBinder);
            this.zzbtk.zzev(iBinder);
            this.zzbtl.zzev(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zza(zza.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzr(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            putDataRequest2.setUrgent();
        }
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            Object object;
            ParcelFileDescriptor parcelFileDescriptor;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() != null) {
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptor[0] + " write:" + parcelFileDescriptor[1]));
                }
                putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptor[0]));
                object = this.zza(parcelFileDescriptor[1], asset.getData());
                entry22.add(object);
                this.zzbkn.submit((Runnable)object);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r");
                    object = Asset.createFromFd(parcelFileDescriptor);
                    putDataRequest2.putAsset((String)entry3.getKey(), (Asset)object);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzbo.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)).zza(new PutDataResponse(4005, null));
                    Log.w((String)"WearableClient", (String)("Couldn't resolve asset URI: " + asset.getUri()));
                    return;
                }
            }
            putDataRequest2.putAsset((String)entry3.getKey(), asset);
        }
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzvt() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzvt();
            }
        });
    }

    public void zza(zza.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzk(zzb2), uri);
    }

    public void zzr(zza.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzax)this.zzqJ()).zzb(new zzbo.zzl(zzb2));
    }

    public void zza(zza.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzl(zzb2), uri, n);
    }

    public void zzb(zza.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzax)this.zzqJ()).zzb((zzav)new zzbo.zze(zzb2), uri, n);
    }

    public void zza(zza.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzax)this.zzqJ()).zza(new zzbo.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zza.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzm(zzb2), asset);
    }

    public void zza(zza.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzs(zza.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzax)this.zzqJ()).zzc(new zzbo.zzn(zzb2));
    }

    public void zzt(zza.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzax)this.zzqJ()).zzd(new zzbo.zzj(zzb2));
    }

    public void zzg(zza.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzg(zzb2), string, n);
    }

    public void zzb(zza.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzf(zzb2), n);
    }

    public void zzr(zza.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzax)this.zzqJ()).zzd(new zzbo.zza(zzb2), string);
    }

    public void zzs(zza.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzax)this.zzqJ()).zze(new zzbo.zzs(zzb2), string);
    }

    public void zze(zza.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzp(zzb2), string, string2);
    }

    public void zzt(zza.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzax)this.zzqJ()).zzf(new zzbo.zzc(zzb2), string);
    }

    public void zzh(zza.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzax)this.zzqJ()).zzb((zzav)new zzbo.zzd(zzb2), string, n);
    }

    public void zzu(zza.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zzqJ()).zza((zzav)new zzbo.zzh(zzb2, zzt2), zzt2, string);
    }

    public void zzv(zza.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzt zzt2 = new zzt();
        ((zzax)this.zzqJ()).zzb((zzav)new zzbo.zzi(zzb2, zzt2), zzt2, string);
    }

    public void zza(zza.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            this.zzbkn.execute(this.zzb(zzb2, string, uri, bl));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzw(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zza.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            this.zzbkn.execute(this.zzb(zzb2, string, uri, l, l2));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzw(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zza.zzb<Status> zzb2, DataApi.DataListener dataListener, zzq<DataApi.DataListener> zzq2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbth.zza(this, zzb2, dataListener, zzbq.zza(zzq2, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, MessageApi.MessageListener messageListener, zzq<MessageApi.MessageListener> zzq2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbti.zza(this, zzb2, messageListener, zzbq.zzb(zzq2, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, NodeApi.NodeListener nodeListener, zzq<NodeApi.NodeListener> zzq2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbtj.zza(this, zzb2, nodeListener, zzbq.zzc(zzq2, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, zzq<CapabilityApi.CapabilityListener> zzq2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbtl.zza(this, zzb2, capabilityListener, zzbq.zze(zzq2, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzq<ChannelApi.ChannelListener> zzq2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzbtg.zza(this, zzb2, channelListener, zzbq.zzd(zzq2, intentFilterArray));
        } else {
            zzbj zzbj2 = new zzbj(string, channelListener);
            this.zzbtg.zza(this, zzb2, zzbj2, zzbq.zza(zzq2, string, intentFilterArray));
        }
    }

    public void zza(zza.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbth.zza(this, zzb2, dataListener);
    }

    public void zza(zza.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbti.zza(this, zzb2, messageListener);
    }

    public void zza(zza.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbtj.zza(this, zzb2, nodeListener);
    }

    public void zza(zza.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzbtl.zza(this, zzb2, capabilityListener);
    }

    public void zza(zza.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbtg.zza(this, zzb2, channelListener);
        } else {
            zzbj zzbj2 = new zzbj(string, channelListener);
            this.zzbtg.zza(this, zzb2, zzbj2);
        }
    }

    private Runnable zzb(final zza.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        zzx.zzz(zzb2);
        zzx.zzz((Object)string);
        zzx.zzz((Object)uri);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzw(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.receiveFile: " + file));
                    zzb2.zzw(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbp.this.zzqJ()).zza((zzav)new zzbo.zzu((zza.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzw(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    private Runnable zzb(final zza.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        zzx.zzz(zzb2);
        zzx.zzz((Object)string);
        zzx.zzz((Object)uri);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzx.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzw(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.sendFile: " + file));
                    zzb2.zzw(new Status(13));
                    return;
                }
                try {
                    ((zzax)zzbp.this.zzqJ()).zza(new zzbo.zzr((zza.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzw(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzew(iBinder);
    }
}

