/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.internal.zzo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
extends AbstractSafeParcelable
implements Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzo();
    final int mVersionCode;
    private final String zzabf;
    private final String zzbBH;
    private final String mPath;

    ChannelImpl(int n, String string, String string2, String string3) {
        this.mVersionCode = n;
        this.zzabf = (String)zzaa.zzz((Object)string);
        this.zzbBH = (String)zzaa.zzz((Object)string2);
        this.mPath = (String)zzaa.zzz((Object)string3);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    public String toString() {
        int n = this.mVersionCode;
        String string = this.zzabf;
        String string2 = this.zzbBH;
        String string3 = this.mPath;
        return new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ChannelImpl{versionCode=").append(n).append(", token='").append(string).append("'").append(", nodeId='").append(string2).append("'").append(", path='").append(string3).append("'").append("}").toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)object;
        return this.zzabf.equals(channelImpl.zzabf) && zzz.equal((Object)channelImpl.zzbBH, (Object)this.zzbBH) && zzz.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.zzabf.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzbBH;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.zzabf;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzx((zznt.zzb<Status>)this, ChannelImpl.this.zzabf);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zzc((zznt.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzi((zznt.zzb<Status>)this, ChannelImpl.this.zzabf, n);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzi<Channel.GetInputStreamResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzy((zznt.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzabf);
            }

            public Channel.GetInputStreamResult zzbE(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbE(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zznt.zza)new zzi<Channel.GetOutputStreamResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzz((zznt.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzabf);
            }

            public Channel.GetOutputStreamResult zzbF(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbF(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient googleApiClient, final Uri uri, final boolean bl) {
        zzaa.zzb((Object)googleApiClient, (Object)"client is null");
        zzaa.zzb((Object)uri, (Object)"uri is null");
        return googleApiClient.zzc((zznt.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<Status>)this, ChannelImpl.this.zzabf, uri, bl);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient googleApiClient, Uri uri) {
        return this.sendFile(googleApiClient, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient googleApiClient, final Uri uri, final long l, final long l2) {
        zzaa.zzb((Object)googleApiClient, (Object)"client is null");
        zzaa.zzb((Object)this.zzabf, (Object)"token is null");
        zzaa.zzb((Object)uri, (Object)"uri is null");
        zzaa.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzaa.zzb((l2 >= 0L || l2 == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return googleApiClient.zzc((zznt.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zznt.zzb<Status>)this, ChannelImpl.this.zzabf, uri, l, l2);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzbn.zzhE("com.google.android.gms.wearable.CHANNEL_EVENT")};
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, ChannelImpl.zza(this.zzabf, intentFilterArray), channelListener);
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        zzaa.zzb((Object)googleApiClient, (Object)"client is null");
        zzaa.zzb((Object)channelListener, (Object)"listener is null");
        return googleApiClient.zzc((zznt.zza)new zzl.zzb(googleApiClient, channelListener, this.zzabf));
    }

    private static zzb.zza<ChannelApi.ChannelListener> zza(final String string, final IntentFilter[] intentFilterArray) {
        return new zzb.zza<ChannelApi.ChannelListener>(){

            @Override
            public void zza(zzbp zzbp2, zznt.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzou<ChannelApi.ChannelListener> zzou2) throws RemoteException {
                zzbp2.zza(zzb2, channelListener, zzou2, string, intentFilterArray);
            }
        };
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzaaO;
        private final OutputStream zzbCP;

        zzb(Status status, OutputStream outputStream) {
            this.zzaaO = (Status)zzaa.zzz((Object)status);
            this.zzbCP = outputStream;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzbCP;
        }

        public void release() {
            if (this.zzbCP != null) {
                try {
                    this.zzbCP.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzaaO;
        private final InputStream zzbCO;

        zza(Status status, InputStream inputStream) {
            this.zzaaO = (Status)zzaa.zzz((Object)status);
            this.zzbCO = inputStream;
        }

        public Status getStatus() {
            return this.zzaaO;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzbCO;
        }

        public void release() {
            if (this.zzbCO != null) {
                try {
                    this.zzbCO.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

