/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.Artifact;
import com.google.android.gms.dependencies.ArtifactVersion;
import com.google.android.gms.dependencies.VersionEvaluator;
import com.google.android.gms.dependencies.VersionEvaluators;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001a\u001a\u00020\u0007J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0007J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/google/android/gms/dependencies/Dependency;", "", "fromArtifactVersion", "Lcom/google/android/gms/dependencies/ArtifactVersion;", "toArtifact", "Lcom/google/android/gms/dependencies/Artifact;", "toArtifactVersionString", "", "(Lcom/google/android/gms/dependencies/ArtifactVersion;Lcom/google/android/gms/dependencies/Artifact;Ljava/lang/String;)V", "getFromArtifactVersion", "()Lcom/google/android/gms/dependencies/ArtifactVersion;", "logger", "Ljava/util/logging/Logger;", "getToArtifact", "()Lcom/google/android/gms/dependencies/Artifact;", "getToArtifactVersionString", "()Ljava/lang/String;", "versionEvaluator", "Lcom/google/android/gms/dependencies/VersionEvaluator;", "component1", "component2", "component3", "copy", "equals", "", "other", "getDisplayString", "hashCode", "", "isVersionCompatible", "versionString", "toString", "Companion", "strict-version-matcher-plugin"})
public final class Dependency {
    private final Logger logger;
    private final VersionEvaluator versionEvaluator;
    @NotNull
    private final ArtifactVersion fromArtifactVersion;
    @NotNull
    private final Artifact toArtifact;
    @NotNull
    private final String toArtifactVersionString;
    public static final Companion Companion = new Companion(null);

    public final boolean isVersionCompatible(@NotNull String versionString) {
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        if (this.versionEvaluator.isCompatible(versionString)) {
            return true;
        }
        this.logger.fine("Failed comparing " + this.toArtifactVersionString + " with" + ' ' + versionString + " using " + this.versionEvaluator.getClass());
        return false;
    }

    @NotNull
    public final String getDisplayString() {
        return this.fromArtifactVersion.getGradleRef() + " -> " + this.toArtifact.getGradleRef() + "@" + this.toArtifactVersionString;
    }

    @NotNull
    public final ArtifactVersion getFromArtifactVersion() {
        return this.fromArtifactVersion;
    }

    @NotNull
    public final Artifact getToArtifact() {
        return this.toArtifact;
    }

    @NotNull
    public final String getToArtifactVersionString() {
        return this.toArtifactVersionString;
    }

    public Dependency(@NotNull ArtifactVersion fromArtifactVersion, @NotNull Artifact toArtifact, @NotNull String toArtifactVersionString) {
        Intrinsics.checkParameterIsNotNull((Object)fromArtifactVersion, (String)"fromArtifactVersion");
        Intrinsics.checkParameterIsNotNull((Object)toArtifact, (String)"toArtifact");
        Intrinsics.checkParameterIsNotNull((Object)toArtifactVersionString, (String)"toArtifactVersionString");
        this.fromArtifactVersion = fromArtifactVersion;
        this.toArtifact = toArtifact;
        this.toArtifactVersionString = toArtifactVersionString;
        Logger logger = Logger.getLogger("Dependency");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(\"Dependency\")");
        this.logger = logger;
        boolean enableStrictMatching = this.toArtifact.getGroupId().equals("com.google.android.gms") || this.toArtifact.getGroupId().equals("com.google.firebase");
        this.versionEvaluator = VersionEvaluators.INSTANCE.getEvaluator(this.toArtifactVersionString, enableStrictMatching);
    }

    @NotNull
    public final ArtifactVersion component1() {
        return this.fromArtifactVersion;
    }

    @NotNull
    public final Artifact component2() {
        return this.toArtifact;
    }

    @NotNull
    public final String component3() {
        return this.toArtifactVersionString;
    }

    @NotNull
    public final Dependency copy(@NotNull ArtifactVersion fromArtifactVersion, @NotNull Artifact toArtifact, @NotNull String toArtifactVersionString) {
        Intrinsics.checkParameterIsNotNull((Object)fromArtifactVersion, (String)"fromArtifactVersion");
        Intrinsics.checkParameterIsNotNull((Object)toArtifact, (String)"toArtifact");
        Intrinsics.checkParameterIsNotNull((Object)toArtifactVersionString, (String)"toArtifactVersionString");
        return new Dependency(fromArtifactVersion, toArtifact, toArtifactVersionString);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Dependency copy$default(Dependency dependency, ArtifactVersion artifactVersion, Artifact artifact, String string, int n, Object object) {
        if ((n & 1) != 0) {
            artifactVersion = dependency.fromArtifactVersion;
        }
        if ((n & 2) != 0) {
            artifact = dependency.toArtifact;
        }
        if ((n & 4) != 0) {
            string = dependency.toArtifactVersionString;
        }
        return dependency.copy(artifactVersion, artifact, string);
    }

    public String toString() {
        return "Dependency(fromArtifactVersion=" + this.fromArtifactVersion + ", toArtifact=" + this.toArtifact + ", toArtifactVersionString=" + this.toArtifactVersionString + ")";
    }

    public int hashCode() {
        ArtifactVersion artifactVersion = this.fromArtifactVersion;
        Artifact artifact = this.toArtifact;
        String string = this.toArtifactVersionString;
        return ((artifactVersion != null ? ((Object)artifactVersion).hashCode() : 0) * 31 + (artifact != null ? ((Object)artifact).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Dependency)) break block3;
                Dependency dependency = (Dependency)object;
                if (!Intrinsics.areEqual((Object)this.fromArtifactVersion, (Object)dependency.fromArtifactVersion) || !Intrinsics.areEqual((Object)this.toArtifact, (Object)dependency.toArtifact) || !Intrinsics.areEqual((Object)this.toArtifactVersionString, (Object)dependency.toArtifactVersionString)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/google/android/gms/dependencies/Dependency$Companion;", "", "()V", "fromArtifactVersions", "Lcom/google/android/gms/dependencies/Dependency;", "fromArtifactVersion", "Lcom/google/android/gms/dependencies/ArtifactVersion;", "toArtifactVersion", "strict-version-matcher-plugin"})
    public static final class Companion {
        @NotNull
        public final Dependency fromArtifactVersions(@NotNull ArtifactVersion fromArtifactVersion, @NotNull ArtifactVersion toArtifactVersion) {
            Intrinsics.checkParameterIsNotNull((Object)fromArtifactVersion, (String)"fromArtifactVersion");
            Intrinsics.checkParameterIsNotNull((Object)toArtifactVersion, (String)"toArtifactVersion");
            return new Dependency(fromArtifactVersion, toArtifactVersion.getArtifact(), toArtifactVersion.getVersion());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

