/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.Artifact;
import com.google.android.gms.dependencies.ArtifactDependencyManager;
import com.google.android.gms.dependencies.ArtifactVersion;
import com.google.android.gms.dependencies.Dependency;
import com.google.android.gms.dependencies.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DependencyAnalyzer {
    private Logger logger = Logging.getLogger(DependencyAnalyzer.class);
    private ArtifactDependencyManager dependencyManager = new ArtifactDependencyManager();

    synchronized void registerDependency(@Nonnull Dependency dependency) {
        this.dependencyManager.addDependency(dependency);
    }

    @Nonnull
    synchronized Collection<Dependency> getActiveDependencies(Collection<ArtifactVersion> versionedArtifacts) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet<ArtifactVersion> artifactVersions = new HashSet<ArtifactVersion>();
        for (ArtifactVersion version : versionedArtifacts) {
            artifacts.add(version.getArtifact());
            artifactVersions.add(version);
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Artifact artifact : artifacts) {
            for (Dependency dep : this.dependencyManager.getDependencies(artifact)) {
                if (!artifactVersions.contains(dep.getFromArtifactVersion()) || !artifacts.contains(dep.getToArtifact())) continue;
                dependencies.add(dep);
            }
        }
        return dependencies;
    }

    synchronized Collection<Node> getPaths(Artifact artifact) {
        ArrayList<Node> pathsToReturn = new ArrayList<Node>();
        Collection<Dependency> deps = this.dependencyManager.getDependencies(artifact);
        for (Dependency dep : deps) {
            this.getNode(pathsToReturn, new Node(null, dep), dep.getFromArtifactVersion());
        }
        return pathsToReturn;
    }

    private synchronized void getNode(ArrayList<Node> terminalPathList, Node n, ArtifactVersion artifactVersion) {
        Collection<Dependency> deps = this.dependencyManager.getDependencies(artifactVersion.getArtifact());
        if (deps.size() < 1) {
            terminalPathList.add(n);
            return;
        }
        for (Dependency dep : deps) {
            if (!dep.isVersionCompatible(artifactVersion.getVersion())) continue;
            this.getNode(terminalPathList, new Node(n, dep), dep.getFromArtifactVersion());
        }
    }
}

