/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.SemVerInfo;
import com.google.android.gms.dependencies.VersionEvaluator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/google/android/gms/dependencies/VersionEvaluators;", "", "()V", "getEvaluator", "Lcom/google/android/gms/dependencies/VersionEvaluator;", "versionString", "", "enableStrictMatching", "", "AlwaysCompatibleEvaluator", "ExactVersionEvaluator", "SemVerVersionEvaluator", "strict-version-matcher-plugin"})
public final class VersionEvaluators {
    public static final VersionEvaluators INSTANCE;

    @NotNull
    public final VersionEvaluator getEvaluator(@NotNull String versionString, boolean enableStrictMatching) {
        VersionEvaluator versionEvaluator;
        boolean hasVersionRange;
        Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
        boolean bl = hasVersionRange = StringsKt.indexOf$default((CharSequence)versionString, (String)",", (int)0, (boolean)false, (int)6, null) > 0 || StringsKt.indexOf$default((CharSequence)versionString, (String)")", (int)0, (boolean)false, (int)6, null) > 0 || StringsKt.indexOf$default((CharSequence)versionString, (String)"(", (int)0, (boolean)false, (int)6, null) > 0;
        if (StringsKt.startsWith$default((String)versionString, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)versionString, (String)"]", (boolean)false, (int)2, null)) {
            ExactVersionEvaluator exactVersionEvaluator;
            String string = versionString;
            int n = 1;
            int n2 = versionString.length() - 1;
            ExactVersionEvaluator exactVersionEvaluator2 = exactVersionEvaluator;
            ExactVersionEvaluator exactVersionEvaluator3 = exactVersionEvaluator;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            exactVersionEvaluator2(string3);
            versionEvaluator = exactVersionEvaluator3;
        } else {
            versionEvaluator = enableStrictMatching && !hasVersionRange ? new AlwaysCompatibleEvaluator() : new AlwaysCompatibleEvaluator();
        }
        return versionEvaluator;
    }

    private VersionEvaluators() {
    }

    static {
        VersionEvaluators versionEvaluators;
        INSTANCE = versionEvaluators = new VersionEvaluators();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/google/android/gms/dependencies/VersionEvaluators$AlwaysCompatibleEvaluator;", "Lcom/google/android/gms/dependencies/VersionEvaluator;", "()V", "isCompatible", "", "version", "", "strict-version-matcher-plugin"})
    public static final class AlwaysCompatibleEvaluator
    implements VersionEvaluator {
        @Override
        public boolean isCompatible(@NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return true;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u000b"}, d2={"Lcom/google/android/gms/dependencies/VersionEvaluators$ExactVersionEvaluator;", "Lcom/google/android/gms/dependencies/VersionEvaluator;", "versionString", "", "(Ljava/lang/String;)V", "getVersionString$strict_version_matcher_plugin", "()Ljava/lang/String;", "setVersionString$strict_version_matcher_plugin", "isCompatible", "", "version", "strict-version-matcher-plugin"})
    public static final class ExactVersionEvaluator
    implements VersionEvaluator {
        @NotNull
        private String versionString;

        @Override
        public boolean isCompatible(@NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return Intrinsics.areEqual((Object)version, (Object)this.versionString);
        }

        @NotNull
        public final String getVersionString$strict_version_matcher_plugin() {
            return this.versionString;
        }

        public final void setVersionString$strict_version_matcher_plugin(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.versionString = string;
        }

        public ExactVersionEvaluator(@NotNull String versionString) {
            Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
            this.versionString = versionString;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/google/android/gms/dependencies/VersionEvaluators$SemVerVersionEvaluator;", "Lcom/google/android/gms/dependencies/VersionEvaluator;", "versionString", "", "(Ljava/lang/String;)V", "versionInfo", "Lcom/google/android/gms/dependencies/SemVerInfo;", "getVersionInfo$strict_version_matcher_plugin", "()Lcom/google/android/gms/dependencies/SemVerInfo;", "setVersionInfo$strict_version_matcher_plugin", "(Lcom/google/android/gms/dependencies/SemVerInfo;)V", "isCompatible", "", "version", "strict-version-matcher-plugin"})
    public static final class SemVerVersionEvaluator
    implements VersionEvaluator {
        @NotNull
        private SemVerInfo versionInfo;

        @NotNull
        public final SemVerInfo getVersionInfo$strict_version_matcher_plugin() {
            return this.versionInfo;
        }

        public final void setVersionInfo$strict_version_matcher_plugin(@NotNull SemVerInfo semVerInfo) {
            Intrinsics.checkParameterIsNotNull((Object)semVerInfo, (String)"<set-?>");
            this.versionInfo = semVerInfo;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isCompatible(@NotNull String version) {
            void major;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            SemVerInfo semVerInfo = SemVerInfo.Companion.parseString(version);
            int n = semVerInfo.component1();
            int minor = semVerInfo.component2();
            return major == this.versionInfo.getMajor() && minor >= this.versionInfo.getMinor();
        }

        public SemVerVersionEvaluator(@NotNull String versionString) {
            Intrinsics.checkParameterIsNotNull((Object)versionString, (String)"versionString");
            this.versionInfo = SemVerInfo.Companion.parseString(versionString);
        }
    }
}

