/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.assetpacks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.VisibleForTesting;
import com.google.android.play.core.assetpacks.AssetPackState;
import com.google.android.play.core.assetpacks.model.AssetPackStatus;
import com.google.android.play.core.assetpacks.model.zzb;
import com.google.android.play.core.assetpacks.zzbb;
import com.google.android.play.core.assetpacks.zzbe;
import com.google.android.play.core.assetpacks.zzbo;
import com.google.android.play.core.assetpacks.zzco;
import com.google.android.play.core.assetpacks.zzdj;
import com.google.android.play.core.assetpacks.zzdk;
import com.google.android.play.core.assetpacks.zzdl;
import com.google.android.play.core.assetpacks.zzdm;
import com.google.android.play.core.assetpacks.zzdn;
import com.google.android.play.core.assetpacks.zzdq;
import com.google.android.play.core.assetpacks.zze;
import com.google.android.play.core.assetpacks.zzeb;
import com.google.android.play.core.assetpacks.zzed;
import com.google.android.play.core.assetpacks.zzy;
import com.google.android.play.core.common.LocalTestingException;
import com.google.android.play.core.internal.zzag;
import com.google.android.play.core.internal.zzcj;
import com.google.android.play.core.tasks.Task;
import com.google.android.play.core.tasks.Tasks;
import com.google.android.play.core.tasks.zzi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

final class zzdo
implements zzy {
    private static final zzag zza;
    private static final AtomicInteger zzb;
    private final String zzc;
    private final zzbb zzd;
    private final zzco zze;
    private final Context zzf;
    private final zzed zzg;
    private final com.google.android.play.core.internal.zzco zzh;
    private final zzeb zzi;
    private final Handler zzj;

    @VisibleForTesting
    static long zzk(@AssetPackStatus int n, long l) {
        switch (n) {
            default: {
                return 0L;
            }
            case 3: 
            case 4: {
                return l;
            }
            case 2: 
        }
        return l / 2L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Bundle zzp(int n, String string, @AssetPackStatus int n2) throws LocalTestingException {
        Bundle bundle = new Bundle();
        bundle.putInt("app_version_code", this.zzg.zza());
        bundle.putInt("session_id", n);
        Object[] objectArray = this.zzs(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = objectArray.length;
        long l = 0L;
        n = 0;
        while (true) {
            void var4_13;
            if (n >= n3) {
                bundle.putStringArrayList(com.google.android.play.core.assetpacks.model.zzb.zza("slice_ids", string), arrayList);
                bundle.putLong(com.google.android.play.core.assetpacks.model.zzb.zza("pack_version", string), (long)this.zzg.zza());
                bundle.putInt(com.google.android.play.core.assetpacks.model.zzb.zza("status", string), n2);
                bundle.putInt(com.google.android.play.core.assetpacks.model.zzb.zza("error_code", string), 0);
                bundle.putLong(com.google.android.play.core.assetpacks.model.zzb.zza("bytes_downloaded", string), zzdo.zzk(n2, l));
                bundle.putLong(com.google.android.play.core.assetpacks.model.zzb.zza("total_bytes_to_download", string), l);
                objectArray = new String[]{string};
                Intent intent = new ArrayList(Arrays.asList(objectArray));
                bundle.putStringArrayList("pack_names", intent);
                bundle.putLong("bytes_downloaded", zzdo.zzk(n2, l));
                bundle.putLong("total_bytes_to_download", l);
                intent = new Intent("com.google.android.play.core.assetpacks.receiver.ACTION_SESSION_UPDATE");
                intent = intent.putExtra("com.google.android.play.core.assetpacks.receiver.EXTRA_SESSION_STATE", bundle);
                string = this.zzj;
                zzdl zzdl2 = new zzdl(this, intent);
                string.post((Runnable)zzdl2);
                return bundle;
            }
            File file = objectArray[n];
            long l2 = l + file.length();
            ArrayList<void> arrayList2 = new ArrayList<void>();
            if (n2 == 3) {
                Intent intent2 = new Intent();
                intent2 = intent2.setData(Uri.EMPTY);
            } else {
                Object var4_15 = null;
            }
            arrayList2.add(var4_13);
            String string2 = zzcj.zza(file);
            bundle.putParcelableArrayList(com.google.android.play.core.assetpacks.model.zzb.zzb("chunk_intents", string, string2), arrayList2);
            bundle.putString(com.google.android.play.core.assetpacks.model.zzb.zzb("uncompressed_hash_sha256", string, string2), zzdo.zzr(file));
            bundle.putLong(com.google.android.play.core.assetpacks.model.zzb.zzb("uncompressed_size", string, string2), file.length());
            arrayList.add(string2);
            ++n;
            l = l2;
        }
    }

    private final AssetPackState zzq(String string, @AssetPackStatus int n) throws LocalTestingException {
        File[] fileArray = this.zzs(string);
        int n2 = fileArray.length;
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l += fileArray[i].length();
        }
        return AssetPackState.zzb(string, n, 0, zzdo.zzk(n, l), l, this.zze.zza(string), 1, String.valueOf(this.zzg.zza()), this.zzi.zza(string));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Task zza(int n, String object, String objectArray, int n2) {
        Object object22 = zza;
        Object[] objectArray2 = new Object[]{n, object, objectArray, n2};
        ((zzag)object22).zzd("getChunkFileDescriptor(session=%d, %s, %s, %d)", objectArray2);
        zzi zzi2 = new zzi();
        try {
            for (Object object22 : this.zzs((String)object)) {
                boolean bl = zzcj.zza((File)object22).equals(objectArray);
                if (!bl) continue;
                zzi2.zzc(ParcelFileDescriptor.open((File)object22, (int)0x10000000));
                return zzi2.zza();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = zza;
            objectArray = new Object[]{fileNotFoundException};
            ((zzag)object).zze("getChunkFileDescriptor failed", objectArray);
            object = new LocalTestingException("Asset Slice file not found.", fileNotFoundException);
            zzi2.zzb((Exception)object);
            return zzi2.zza();
        }
        catch (LocalTestingException localTestingException) {
            object = zza;
            objectArray = new Object[]{localTestingException};
            ((zzag)object).zze("getChunkFileDescriptor failed", objectArray);
            zzi2.zzb(localTestingException);
            return zzi2.zza();
        }
        {
            object = new Object[]{objectArray};
            LocalTestingException localTestingException = new LocalTestingException(String.format("Local testing slice for '%s' not found.", (Object[])object));
            throw localTestingException;
        }
    }

    @Override
    public final Task zzb(List list, zzbe zzbe2, Map object) {
        object = zza;
        Object object2 = new Object[]{list};
        ((zzag)object).zzd("getPackStates(%s)", (Object[])object2);
        object = new zzi();
        object2 = this.zzh;
        object2 = object2.zza();
        object2 = (Executor)object2;
        zzdm zzdm2 = new zzdm(this, list, zzbe2, (zzi)object);
        object2.execute(zzdm2);
        return ((zzi)object).zza();
    }

    @Override
    public final Task zzc(List list, List list2, Map object) {
        object = zza;
        Object object2 = new Object[]{list2};
        ((zzag)object).zzd("startDownload(%s)", (Object[])object2);
        object = new zzi();
        object2 = this.zzh;
        object2 = object2.zza();
        object2 = (Executor)object2;
        zzdn zzdn2 = new zzdn(this, list2, (zzi)object, list);
        object2.execute(zzdn2);
        return ((zzi)object).zza();
    }

    @Override
    public final Task zzd(Map map) {
        zza.zzd("syncPacks()", new Object[0]);
        ArrayList arrayList = new ArrayList();
        return Tasks.zzb(arrayList);
    }

    private static String zzr(File file) throws LocalTestingException {
        Object object;
        try {
            object = new File[]{file};
            object = zzdq.zza(Arrays.asList(object));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{file};
            LocalTestingException localTestingException = new LocalTestingException(String.format("Could not digest file: %s.", objectArray), iOException);
            throw localTestingException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LocalTestingException localTestingException = new LocalTestingException("SHA256 algorithm not supported.", noSuchAlgorithmException);
            throw localTestingException;
        }
        return object;
    }

    static {
        Object object = new zzag("FakeAssetPackService");
        zza = object;
        zzb = object = new AtomicInteger(1);
    }

    @VisibleForTesting
    zzdo(File file, zzbb zzbb2, zzco zzco2, Context context, zzed zzed2, com.google.android.play.core.internal.zzco zzco3, zzeb zzeb2) {
        Handler handler;
        this.zzj = handler = new Handler(Looper.getMainLooper());
        this.zzc = file.getAbsolutePath();
        this.zzd = zzbb2;
        this.zze = zzco2;
        this.zzf = context;
        this.zzg = zzed2;
        this.zzh = zzco3;
        this.zzi = zzeb2;
    }

    @Override
    public final void zze(List list) {
        zzag zzag2 = zza;
        Object[] objectArray = new Object[]{list};
        zzag2.zzd("cancelDownload(%s)", objectArray);
    }

    @Override
    public final void zzf() {
        zza.zzd("keepAlive", new Object[0]);
    }

    final /* synthetic */ void zzl(Intent intent) {
        this.zzd.zza(this.zzf, intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzm(List object, zzbe zzbe2, zzi zzi2) {
        HashMap<String, AssetPackState> hashMap = new HashMap<String, AssetPackState>();
        object = object.iterator();
        long l = 0L;
        while (true) {
            Object object2;
            if (!object.hasNext()) {
                object2 = new zzbo(l, hashMap);
                zzi2.zzc(object2);
                return;
            }
            String string = (String)object.next();
            int n = ((zze)zzbe2).zza.zza(8, string);
            try {
                AssetPackState assetPackState = super.zzq(string, n);
                l += assetPackState.totalBytesToDownload();
                hashMap.put(string, assetPackState);
            }
            catch (LocalTestingException localTestingException) {
                zzi2.zzb(localTestingException);
                return;
            }
        }
    }

    final /* synthetic */ void zzn(int n, String objectArray) {
        try {
            this.zzp(n, (String)objectArray, 4);
            return;
        }
        catch (LocalTestingException localTestingException) {
            zzag zzag2 = zza;
            objectArray = new Object[]{localTestingException};
            zzag2.zze("notifyModuleCompleted failed", objectArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzo(List iterator, zzi zzi2, List object) {
        Object object3;
        HashMap<Object, AssetPackState> hashMap = new HashMap<Object, AssetPackState>();
        Object object2 = iterator.iterator();
        long l = 0L;
        while (object2.hasNext()) {
            String string = (String)object2.next();
            try {
                AssetPackState assetPackState = ((zzdo)object3).zzq(string, 1);
                l += assetPackState.totalBytesToDownload();
                hashMap.put(string, assetPackState);
            }
            catch (LocalTestingException localTestingException) {
                zzi2.zzb(localTestingException);
                return;
            }
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            try {
                int n = zzb.getAndIncrement();
                super.zzp(n, (String)object2, 1);
                super.zzp(n, (String)object2, 2);
                super.zzp(n, (String)object2, 3);
            }
            catch (LocalTestingException localTestingException) {
                zzi2.zzb(localTestingException);
                return;
            }
        }
        iterator = object.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                object3 = new zzbo(l, hashMap);
                zzi2.zzc(object3);
                return;
            }
            object = (String)iterator.next();
            hashMap.put(object, AssetPackState.zzb((String)object, 4, 0, 0L, 0L, 0.0, 1, String.valueOf(((zzdo)object3).zzg.zza()), String.valueOf(((zzdo)object3).zzg.zza())));
        }
    }

    @Override
    public final void zzg(int n, String string, String string2, int n2) {
        zza.zzd("notifyChunkTransferred", new Object[0]);
    }

    @Override
    public final void zzh(int n, String string) {
        zza.zzd("notifyModuleCompleted", new Object[0]);
        Object object = this.zzh;
        object = object.zza();
        object = (Executor)object;
        zzdk zzdk2 = new zzdk(this, n, string);
        object.execute(zzdk2);
    }

    @Override
    public final void zzi(int n) {
        zza.zzd("notifySessionFailed", new Object[0]);
    }

    @Override
    public final void zzj(String string) {
        zzag zzag2 = zza;
        Object[] objectArray = new Object[]{string};
        zzag2.zzd("removePack(%s)", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final File[] zzs(String objectArray) throws LocalTestingException {
        Object object;
        Object[] objectArray2 = new File(((zzdo)object).zzc);
        if (!objectArray2.isDirectory()) {
            objectArray = new Object[]{objectArray2};
            object = new LocalTestingException(String.format("Local testing directory '%s' not found.", objectArray));
            throw object;
        }
        object = new zzdj((String)objectArray);
        if ((objectArray2 = objectArray2.listFiles((FilenameFilter)object)) == null) {
            objectArray2 = new Object[]{objectArray};
            object = new LocalTestingException(String.format("Failed fetching APKs for pack '%s'.", objectArray2));
            throw object;
        }
        int n = objectArray2.length;
        if (n == 0) {
            objectArray2 = new Object[]{objectArray};
            object = new LocalTestingException(String.format("No APKs available for pack '%s'.", objectArray2));
            throw object;
        }
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                objectArray2 = new Object[]{objectArray};
                LocalTestingException localTestingException = new LocalTestingException(String.format("No main slice available for pack '%s'.", objectArray2));
                throw localTestingException;
            }
            if (zzcj.zza((File)objectArray2[n2]).equals(objectArray)) {
                return objectArray2;
            }
            ++n2;
        }
    }
}

