/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.GeneralForStatement;
import com.google.api.generator.engine.ast.Statement;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class AutoValue_GeneralForStatement
extends GeneralForStatement {
    private final Expr initializationExpr;
    private final Expr terminationExpr;
    private final Expr updateExpr;
    private final ImmutableList<Statement> body;

    private AutoValue_GeneralForStatement(Expr initializationExpr, Expr terminationExpr, Expr updateExpr, ImmutableList<Statement> body) {
        this.initializationExpr = initializationExpr;
        this.terminationExpr = terminationExpr;
        this.updateExpr = updateExpr;
        this.body = body;
    }

    @Override
    public Expr initializationExpr() {
        return this.initializationExpr;
    }

    @Override
    public Expr terminationExpr() {
        return this.terminationExpr;
    }

    @Override
    public Expr updateExpr() {
        return this.updateExpr;
    }

    @Override
    public ImmutableList<Statement> body() {
        return this.body;
    }

    public String toString() {
        return "GeneralForStatement{initializationExpr=" + this.initializationExpr + ", terminationExpr=" + this.terminationExpr + ", updateExpr=" + this.updateExpr + ", body=" + this.body + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GeneralForStatement) {
            GeneralForStatement that = (GeneralForStatement)o;
            return this.initializationExpr.equals(that.initializationExpr()) && this.terminationExpr.equals(that.terminationExpr()) && this.updateExpr.equals(that.updateExpr()) && this.body.equals(that.body());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.initializationExpr.hashCode();
        h$ *= 1000003;
        h$ ^= this.terminationExpr.hashCode();
        h$ *= 1000003;
        h$ ^= this.updateExpr.hashCode();
        h$ *= 1000003;
        return h$ ^= this.body.hashCode();
    }

    static final class Builder
    extends GeneralForStatement.Builder {
        private Expr initializationExpr;
        private Expr terminationExpr;
        private Expr updateExpr;
        private ImmutableList<Statement> body;

        Builder() {
        }

        @Override
        GeneralForStatement.Builder setInitializationExpr(Expr initializationExpr) {
            if (initializationExpr == null) {
                throw new NullPointerException("Null initializationExpr");
            }
            this.initializationExpr = initializationExpr;
            return this;
        }

        @Override
        GeneralForStatement.Builder setTerminationExpr(Expr terminationExpr) {
            if (terminationExpr == null) {
                throw new NullPointerException("Null terminationExpr");
            }
            this.terminationExpr = terminationExpr;
            return this;
        }

        @Override
        GeneralForStatement.Builder setUpdateExpr(Expr updateExpr) {
            if (updateExpr == null) {
                throw new NullPointerException("Null updateExpr");
            }
            this.updateExpr = updateExpr;
            return this;
        }

        @Override
        GeneralForStatement.Builder setBody(List<Statement> body) {
            this.body = ImmutableList.copyOf(body);
            return this;
        }

        @Override
        GeneralForStatement autoBuild() {
            if (this.initializationExpr == null || this.terminationExpr == null || this.updateExpr == null || this.body == null) {
                StringBuilder missing = new StringBuilder();
                if (this.initializationExpr == null) {
                    missing.append(" initializationExpr");
                }
                if (this.terminationExpr == null) {
                    missing.append(" terminationExpr");
                }
                if (this.updateExpr == null) {
                    missing.append(" updateExpr");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GeneralForStatement(this.initializationExpr, this.terminationExpr, this.updateExpr, this.body);
        }
    }
}

