/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ThrowExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@AutoValue
public abstract class ThrowExpr
implements Expr {
    @Nullable
    public abstract Expr throwExpr();

    @Override
    public abstract TypeNode type();

    @Nullable
    public abstract Expr messageExpr();

    @Nullable
    public abstract Expr causeExpr();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_ThrowExpr.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setThrowExpr(Expr var1);

        public abstract Builder setType(TypeNode var1);

        public Builder setMessageExpr(String message) {
            return this.setMessageExpr(ValueExpr.withValue(StringObjectValue.withValue(message)));
        }

        public abstract Builder setMessageExpr(Expr var1);

        public abstract Builder setCauseExpr(Expr var1);

        abstract Expr throwExpr();

        abstract TypeNode type();

        abstract Expr messageExpr();

        abstract Expr causeExpr();

        abstract ThrowExpr autoBuild();

        public ThrowExpr build() {
            if (this.throwExpr() != null) {
                this.setType(this.throwExpr().type());
                Preconditions.checkState(this.messageExpr() == null && this.causeExpr() == null, "Only one of throwExpr or [messageExpr or causeExpr, inclusive] can be present.");
                if (this.throwExpr() instanceof VariableExpr) {
                    Preconditions.checkState(!((VariableExpr)this.throwExpr()).isDecl(), "Cannot throw a variable declaration");
                }
                Preconditions.checkState(TypeNode.isExceptionType(this.throwExpr().type()), String.format("Only exception types can be thrown, found %s", this.throwExpr().type()));
                return this.autoBuild();
            }
            Preconditions.checkState(TypeNode.isExceptionType(this.type()), String.format("Type %s must be an exception type", this.type()));
            if (this.messageExpr() != null) {
                Preconditions.checkState(this.messageExpr().type().equals(TypeNode.STRING), String.format("Message expression type must be a string for exception %s", this.type()));
            }
            if (this.causeExpr() != null) {
                Preconditions.checkState(TypeNode.THROWABLE.reference().isSupertypeOrEquals(this.causeExpr().type().reference()), String.format("Cause expression type must be a subclass of Throwable, but found %s", this.causeExpr().type()));
            }
            return this.autoBuild();
        }
    }
}

