/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_TryCatchStatement;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class TryCatchStatement
implements Statement {
    public abstract ImmutableList<Statement> tryBody();

    public abstract List<VariableExpr> catchVariableExprs();

    public abstract List<List<Statement>> catchBlocks();

    @Nullable
    public abstract AssignmentExpr tryResourceExpr();

    public abstract boolean isSampleCode();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_TryCatchStatement.Builder().setCatchVariableExprs(Collections.emptyList()).setCatchBlocks(Collections.emptyList()).setIsSampleCode(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTryResourceExpr(AssignmentExpr var1);

        public abstract Builder setTryBody(List<Statement> var1);

        public abstract Builder setIsSampleCode(boolean var1);

        public Builder addCatch(@Nonnull VariableExpr variableExpr, List<Statement> body) {
            ArrayList<VariableExpr> catchVarExprs = new ArrayList<VariableExpr>(this.catchVariableExprs());
            catchVarExprs.add(variableExpr);
            this.setCatchVariableExprs(catchVarExprs);
            ArrayList<List<Statement>> blocks = new ArrayList<List<Statement>>(this.catchBlocks());
            blocks.add(body);
            return this.setCatchBlocks(blocks);
        }

        abstract Builder setCatchVariableExprs(List<VariableExpr> var1);

        abstract Builder setCatchBlocks(List<List<Statement>> var1);

        abstract ImmutableList<Statement> tryBody();

        abstract boolean isSampleCode();

        abstract List<VariableExpr> catchVariableExprs();

        abstract List<List<Statement>> catchBlocks();

        abstract TryCatchStatement autoBuild();

        public TryCatchStatement build() {
            NodeValidator.checkNoNullElements(this.tryBody(), "try body", "try-catch");
            NodeValidator.checkNoNullElements(this.catchVariableExprs(), "catch variable expressions", "try-catch");
            this.catchBlocks().forEach(body -> NodeValidator.checkNoNullElements(body, "catch body", "try-catch"));
            if (!this.isSampleCode()) {
                Preconditions.checkState(!this.catchVariableExprs().isEmpty(), "Catch variable expression must be set for real, non-sample try-catch blocks.");
                Preconditions.checkState(this.catchVariableExprs().stream().allMatch(v -> v.isDecl()), "Catch variable expressions must all be declarations");
                Preconditions.checkState(this.catchVariableExprs().stream().allMatch(v -> TypeNode.isExceptionType(v.variable().type())), "Catch variables must be an Exception object references");
            }
            Preconditions.checkState(this.catchVariableExprs().size() == this.catchBlocks().size(), String.format("%d catch variables found and %d blocks found, but these numbers must be equal", this.catchVariableExprs().size(), this.catchBlocks().size()));
            return this.autoBuild();
        }
    }
}

