/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.resourcename;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceNameTokenizer {
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String SLASH = "/";
    private static final String EMPTY = "";
    private static final String EQUALS_WILDCARD = "=*";
    private static final String EQUALS_PATH_WILDCARD = "=**";
    private static final String NON_SLASH_SEP_REGEX = "\\}(_|\\-|\\.|~)\\{";

    public static List<List<String>> parseTokenHierarchy(List<String> patterns) {
        ArrayList<List<String>> tokenHierachies = new ArrayList<List<String>>();
        for (String pattern : patterns) {
            ArrayList<String> hierarchy = new ArrayList<String>();
            Set<String> vars = PathTemplate.create(pattern).vars();
            String[] rawPatternTokens = pattern.split(SLASH);
            ArrayList<String> patternTokens = new ArrayList<String>();
            for (String rawPatternToken : rawPatternTokens) {
                if (rawPatternToken.equals("_deleted-topic_")) {
                    hierarchy.add(rawPatternToken);
                    continue;
                }
                if (!rawPatternToken.startsWith(LEFT_BRACE) || !rawPatternToken.endsWith(RIGHT_BRACE)) continue;
                for (String subToken : rawPatternToken.split(NON_SLASH_SEP_REGEX)) {
                    String processedSubToken = subToken.replace(LEFT_BRACE, EMPTY).replace(RIGHT_BRACE, EMPTY);
                    if (patternTokens.contains(processedSubToken)) continue;
                    patternTokens.add(processedSubToken);
                }
            }
            for (String patternToken : patternTokens) {
                String processedPatternToken = patternToken.replace(EQUALS_PATH_WILDCARD, EMPTY).replace(EQUALS_WILDCARD, EMPTY);
                List candidateVars = vars.stream().filter(v -> processedPatternToken.equals(v)).collect(Collectors.toList());
                Preconditions.checkState(!candidateVars.isEmpty(), String.format("No variable candidates found for token %s in pattern %s among variables %s", processedPatternToken, pattern, vars));
                hierarchy.add(processedPatternToken);
            }
            tokenHierachies.add(hierarchy);
        }
        return tokenHierachies;
    }
}

