/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.ResourceDescriptor;
import com.google.api.ResourceProto;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.protoparser.TypeParser;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ResourceNameParser {
    public static Map<String, ResourceName> parseResourceNames(Descriptors.FileDescriptor fileDescriptor, String javaPackage) {
        Map<String, ResourceName> resourceNames = ResourceNameParser.parseResourceNamesFromFile(fileDescriptor, javaPackage);
        String pakkage = fileDescriptor.getOptions().getJavaPackage();
        if (Strings.isNullOrEmpty(pakkage)) {
            pakkage = javaPackage;
        }
        resourceNames.putAll(ResourceNameParser.parseResourceNamesFromMessages(fileDescriptor.getMessageTypes(), pakkage));
        return resourceNames;
    }

    @VisibleForTesting
    public static Map<String, ResourceName> parseResourceNames(Descriptors.FileDescriptor fileDescriptor) {
        String pakkage = TypeParser.getPackage(fileDescriptor);
        return ResourceNameParser.parseResourceNames(fileDescriptor, pakkage);
    }

    @VisibleForTesting
    static Map<String, ResourceName> parseResourceNamesFromFile(Descriptors.FileDescriptor fileDescriptor) {
        String pakkage = TypeParser.getPackage(fileDescriptor);
        return ResourceNameParser.parseResourceNamesFromFile(fileDescriptor, pakkage);
    }

    @VisibleForTesting
    static Map<String, ResourceName> parseResourceNamesFromFile(Descriptors.FileDescriptor fileDescriptor, String javaPackage) {
        HashMap<String, ResourceName> typeStringToResourceNames = new HashMap<String, ResourceName>();
        DescriptorProtos.FileOptions fileOptions = fileDescriptor.getOptions();
        if (fileOptions.getExtensionCount(ResourceProto.resourceDefinition) <= 0) {
            return typeStringToResourceNames;
        }
        List<ResourceDescriptor> protoResources = fileOptions.getExtension(ResourceProto.resourceDefinition);
        for (ResourceDescriptor protoResource : protoResources) {
            Optional<ResourceName> resourceNameModelOpt = ResourceNameParser.createResourceName(protoResource, javaPackage);
            if (!resourceNameModelOpt.isPresent()) continue;
            ResourceName resourceNameModel = resourceNameModelOpt.get();
            typeStringToResourceNames.put(resourceNameModel.resourceTypeString(), resourceNameModel);
        }
        return typeStringToResourceNames;
    }

    @VisibleForTesting
    static Map<String, ResourceName> parseResourceNamesFromMessages(List<Descriptors.Descriptor> messageTypeDescriptors, String pakkage) {
        HashMap<String, ResourceName> resourceNames = new HashMap<String, ResourceName>();
        for (Descriptors.Descriptor messageTypeDescriptor : messageTypeDescriptors) {
            Optional<ResourceName> resourceNameModelOpt = ResourceNameParser.parseResourceNameFromMessageType(messageTypeDescriptor, pakkage);
            if (!resourceNameModelOpt.isPresent()) continue;
            ResourceName resourceName = resourceNameModelOpt.get();
            resourceNames.put(resourceName.resourceTypeString(), resourceName);
        }
        return resourceNames;
    }

    @VisibleForTesting
    static Optional<ResourceName> parseResourceNameFromMessageType(Descriptors.Descriptor messageTypeDescriptor, String pakkage) {
        DescriptorProtos.MessageOptions messageOptions = messageTypeDescriptor.getOptions();
        if (!messageOptions.hasExtension(ResourceProto.resource)) {
            return Optional.empty();
        }
        ResourceDescriptor protoResource = messageOptions.getExtension(ResourceProto.resource);
        if (Strings.isNullOrEmpty(protoResource.getNameField())) {
            boolean resourceNameFieldFound = messageTypeDescriptor.findFieldByName("name") != null;
            for (Descriptors.FieldDescriptor fieldDescriptor : messageTypeDescriptor.getFields()) {
                DescriptorProtos.FieldOptions fieldOptions = fieldDescriptor.getOptions();
                if (!fieldOptions.hasExtension(ResourceProto.resourceReference)) continue;
                resourceNameFieldFound = true;
                break;
            }
            Preconditions.checkState(resourceNameFieldFound, String.format("Message %s has a resource annotation but no field titled \"name\" or containing a resource reference", messageTypeDescriptor.getName()));
        }
        TypeNode javaMessageType = TypeParser.parseType(messageTypeDescriptor);
        return ResourceNameParser.createResourceName(protoResource, pakkage, javaMessageType.reference().fullName());
    }

    private static Optional<ResourceName> createResourceName(ResourceDescriptor protoResource, String pakkage) {
        return ResourceNameParser.createResourceName(protoResource, pakkage, null);
    }

    private static Optional<ResourceName> createResourceName(ResourceDescriptor protoResource, String pakkage, String parentMessageName) {
        ArrayList<String> patterns = new ArrayList<String>(protoResource.getPatternList());
        Preconditions.checkState(!patterns.isEmpty(), String.format("Resource name definition for %s must have at least one pattern", protoResource.getType()));
        if (patterns.size() == 1 && ((String)patterns.get(0)).equals("*")) {
            return Optional.of(ResourceName.createWildcard(protoResource.getType(), pakkage));
        }
        Optional<Object> resourceVariableNameOpt = Optional.empty();
        for (int i = 0; i < patterns.size() && !(resourceVariableNameOpt = ResourceNameParser.getVariableNameFromPattern((String)patterns.get(i))).isPresent(); ++i) {
        }
        Preconditions.checkState(resourceVariableNameOpt.isPresent(), String.format("Resource variable name not found in patterns %s", patterns));
        if (patterns.contains("*")) {
            patterns.remove("*");
        }
        return Optional.of(ResourceName.builder().setVariableName((String)resourceVariableNameOpt.get()).setPakkage(pakkage).setResourceTypeString(protoResource.getType()).setPatterns(patterns).setParentMessageName(parentMessageName).build());
    }

    @VisibleForTesting
    static Optional<String> getVariableNameFromPattern(String pattern) {
        String resourceVariableName = null;
        String[] tokens = pattern.split("/");
        String lastToken = tokens[tokens.length - 1];
        if (lastToken.equals("_deleted-topic_")) {
            resourceVariableName = lastToken;
        } else if (lastToken.equals("*")) {
            resourceVariableName = null;
        } else if (!lastToken.contains("{")) {
            resourceVariableName = lastToken;
        } else {
            Set<String> variableNames = PathTemplate.create(pattern).vars();
            for (String variableName : variableNames) {
                if (!lastToken.contains(variableName)) continue;
                resourceVariableName = variableName;
                break;
            }
        }
        return Strings.isNullOrEmpty(resourceVariableName) ? Optional.empty() : Optional.of(resourceVariableName);
    }
}

