/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Set;
import java.util.concurrent.CancellationException;

class GrpcExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    GrpcExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<StatusCode.Code> retryableCodes) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        GrpcCallContext context = GrpcCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture innerCallFuture = this.callable.futureCall(request, (ApiCallContext)context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback((ApiFuture)innerCallFuture, (ApiFutureCallback)transformingFuture);
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof StatusException) {
                StatusException e = (StatusException)throwable;
                this.setException(throwable, e.getStatus().getCode());
            } else if (throwable instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)throwable;
                this.setException(throwable, e.getStatus().getCode());
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                if (throwable instanceof ApiException) {
                    super.setException(throwable);
                } else {
                    super.setException((Throwable)ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)GrpcStatusCode.of(Status.Code.UNKNOWN), (boolean)false));
                }
            }
        }

        private void setException(Throwable throwable, Status.Code statusCode) {
            boolean canRetry = GrpcExceptionCallable.this.retryableCodes.contains((Object)GrpcStatusCode.grpcCodeToStatusCode(statusCode));
            super.setException((Throwable)ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)GrpcStatusCode.of(statusCode), (boolean)canRetry));
        }
    }
}

