/*
 * Decompiled with CFR 0.152.
 */
package com.google.area120.tables.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RowName
implements ResourceName {
    private static final PathTemplate TABLE_ROW = PathTemplate.createWithoutUrlEncoding((String)"tables/{table}/rows/{row}");
    private volatile Map<String, String> fieldValuesMap;
    private final String table;
    private final String row;

    @Deprecated
    protected RowName() {
        this.table = null;
        this.row = null;
    }

    private RowName(Builder builder) {
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
        this.row = (String)Preconditions.checkNotNull((Object)builder.getRow());
    }

    public String getTable() {
        return this.table;
    }

    public String getRow() {
        return this.row;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RowName of(String table, String row) {
        return RowName.newBuilder().setTable(table).setRow(row).build();
    }

    public static String format(String table, String row) {
        return RowName.newBuilder().setTable(table).setRow(row).build().toString();
    }

    public static RowName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TABLE_ROW.validatedMatch(formattedString, "RowName.parse: formattedString not in valid format");
        return RowName.of((String)matchMap.get("table"), (String)matchMap.get("row"));
    }

    public static List<RowName> parseList(List<String> formattedStrings) {
        ArrayList<RowName> list = new ArrayList<RowName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RowName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RowName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RowName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TABLE_ROW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RowName rowName = this;
            synchronized (rowName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.table != null) {
                        fieldMapBuilder.put((Object)"table", (Object)this.table);
                    }
                    if (this.row != null) {
                        fieldMapBuilder.put((Object)"row", (Object)this.row);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TABLE_ROW.instantiate(new String[]{"table", this.table, "row", this.row});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RowName that = (RowName)o;
            return Objects.equals(this.table, that.table) && Objects.equals(this.row, that.row);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.table);
        h *= 1000003;
        return h ^= Objects.hashCode(this.row);
    }

    public static class Builder {
        private String table;
        private String row;

        protected Builder() {
        }

        public String getTable() {
            return this.table;
        }

        public String getRow() {
            return this.row;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setRow(String row) {
            this.row = row;
            return this;
        }

        private Builder(RowName rowName) {
            this.table = rowName.table;
            this.row = rowName.row;
        }

        public RowName build() {
            return new RowName(this);
        }
    }
}

