/*
 * Decompiled with CFR 0.152.
 */
package com.google.area120.tables.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableName
implements ResourceName {
    private static final PathTemplate TABLE = PathTemplate.createWithoutUrlEncoding((String)"tables/{table}");
    private volatile Map<String, String> fieldValuesMap;
    private final String table;

    @Deprecated
    protected TableName() {
        this.table = null;
    }

    private TableName(Builder builder) {
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
    }

    public String getTable() {
        return this.table;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TableName of(String table) {
        return TableName.newBuilder().setTable(table).build();
    }

    public static String format(String table) {
        return TableName.newBuilder().setTable(table).build().toString();
    }

    public static TableName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TABLE.validatedMatch(formattedString, "TableName.parse: formattedString not in valid format");
        return TableName.of((String)matchMap.get("table"));
    }

    public static List<TableName> parseList(List<String> formattedStrings) {
        ArrayList<TableName> list = new ArrayList<TableName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TableName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TableName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TableName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TABLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TableName tableName = this;
            synchronized (tableName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.table != null) {
                        fieldMapBuilder.put((Object)"table", (Object)this.table);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TABLE.instantiate(new String[]{"table", this.table});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TableName that = (TableName)o;
            return Objects.equals(this.table, that.table);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.table);
    }

    public static class Builder {
        private String table;

        protected Builder() {
        }

        public String getTable() {
            return this.table;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        private Builder(TableName tableName) {
            this.table = tableName.table;
        }

        public TableName build() {
            return new TableName(this);
        }
    }
}

