/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/migratable_resource.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Represents one resource that exists in automl.googleapis.com,
 * datalabeling.googleapis.com or ml.googleapis.com.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource}
 */
public final class MigratableResource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource)
    MigratableResourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigratableResource.newBuilder() to construct.
  private MigratableResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigratableResource() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigratableResource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.MigratableResourceProto
        .internal_static_google_cloud_aiplatform_v1_MigratableResource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.MigratableResourceProto
        .internal_static_google_cloud_aiplatform_v1_MigratableResource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.MigratableResource.class,
            com.google.cloud.aiplatform.v1.MigratableResource.Builder.class);
  }

  public interface MlEngineModelVersionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ml.googleapis.com endpoint that this model Version currently lives
     * in.
     * Example values:
     *
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1;</code>
     *
     * @return The endpoint.
     */
    java.lang.String getEndpoint();
    /**
     *
     *
     * <pre>
     * The ml.googleapis.com endpoint that this model Version currently lives
     * in.
     * Example values:
     *
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1;</code>
     *
     * @return The bytes for endpoint.
     */
    com.google.protobuf.ByteString getEndpointBytes();

    /**
     *
     *
     * <pre>
     * Full resource name of ml engine model Version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * Full resource name of ml engine model Version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents one model Version in ml.googleapis.com.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion}
   */
  public static final class MlEngineModelVersion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
      MlEngineModelVersionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MlEngineModelVersion.newBuilder() to construct.
    private MlEngineModelVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MlEngineModelVersion() {
      endpoint_ = "";
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MlEngineModelVersion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_MlEngineModelVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_MlEngineModelVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.class,
              com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder.class);
    }

    public static final int ENDPOINT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * The ml.googleapis.com endpoint that this model Version currently lives
     * in.
     * Example values:
     *
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1;</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ml.googleapis.com endpoint that this model Version currently lives
     * in.
     * Example values:
     *
     * * ml.googleapis.com
     * * us-centrall-ml.googleapis.com
     * * europe-west4-ml.googleapis.com
     * * asia-east1-ml.googleapis.com
     * </pre>
     *
     * <code>string endpoint = 1;</code>
     *
     * @return The bytes for endpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of ml engine model Version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of ml engine model Version.
     * Format: `projects/{project}/models/{model}/versions/{version}`.
     * </pre>
     *
     * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, version_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion other =
          (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) obj;

      if (!getEndpoint().equals(other.getEndpoint())) return false;
      if (!getVersion().equals(other.getVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents one model Version in ml.googleapis.com.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_MlEngineModelVersion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_MlEngineModelVersion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.class,
                com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpoint_ = "";
        version_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_MlEngineModelVersion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion build() {
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion buildPartial() {
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion result =
            new com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endpoint_ = endpoint_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.version_ = version_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion other) {
        if (other
            == com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
                .getDefaultInstance()) return this;
        if (!other.getEndpoint().isEmpty()) {
          endpoint_ = other.endpoint_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  endpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object endpoint_ = "";
      /**
       *
       *
       * <pre>
       * The ml.googleapis.com endpoint that this model Version currently lives
       * in.
       * Example values:
       *
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1;</code>
       *
       * @return The endpoint.
       */
      public java.lang.String getEndpoint() {
        java.lang.Object ref = endpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ml.googleapis.com endpoint that this model Version currently lives
       * in.
       * Example values:
       *
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1;</code>
       *
       * @return The bytes for endpoint.
       */
      public com.google.protobuf.ByteString getEndpointBytes() {
        java.lang.Object ref = endpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ml.googleapis.com endpoint that this model Version currently lives
       * in.
       * Example values:
       *
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1;</code>
       *
       * @param value The endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ml.googleapis.com endpoint that this model Version currently lives
       * in.
       * Example values:
       *
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoint() {
        endpoint_ = getDefaultInstance().getEndpoint();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ml.googleapis.com endpoint that this model Version currently lives
       * in.
       * Example values:
       *
       * * ml.googleapis.com
       * * us-centrall-ml.googleapis.com
       * * europe-west4-ml.googleapis.com
       * * asia-east1-ml.googleapis.com
       * </pre>
       *
       * <code>string endpoint = 1;</code>
       *
       * @param value The bytes for endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * Full resource name of ml engine model Version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of ml engine model Version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of ml engine model Version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of ml engine model Version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of ml engine model Version.
       * Format: `projects/{project}/models/{model}/versions/{version}`.
       * </pre>
       *
       * <code>string version = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
    private static final com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion();
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MlEngineModelVersion> PARSER =
        new com.google.protobuf.AbstractParser<MlEngineModelVersion>() {
          @java.lang.Override
          public MlEngineModelVersion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MlEngineModelVersion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MlEngineModelVersion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutomlModelOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.MigratableResource.AutomlModel)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();

    /**
     *
     *
     * <pre>
     * The Model's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string model_display_name = 3;</code>
     *
     * @return The modelDisplayName.
     */
    java.lang.String getModelDisplayName();
    /**
     *
     *
     * <pre>
     * The Model's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string model_display_name = 3;</code>
     *
     * @return The bytes for modelDisplayName.
     */
    com.google.protobuf.ByteString getModelDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents one Model in automl.googleapis.com.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.AutomlModel}
   */
  public static final class AutomlModel extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource.AutomlModel)
      AutomlModelOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutomlModel.newBuilder() to construct.
    private AutomlModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutomlModel() {
      model_ = "";
      modelDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutomlModel();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.class,
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder.class);
    }

    public static final int MODEL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of automl Model.
     * Format:
     * `projects/{project}/locations/{location}/models/{model}`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_DISPLAY_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The Model's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string model_display_name = 3;</code>
     *
     * @return The modelDisplayName.
     */
    @java.lang.Override
    public java.lang.String getModelDisplayName() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Model's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string model_display_name = 3;</code>
     *
     * @return The bytes for modelDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelDisplayNameBytes() {
      java.lang.Object ref = modelDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelDisplayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelDisplayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel other =
          (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) obj;

      if (!getModel().equals(other.getModel())) return false;
      if (!getModelDisplayName().equals(other.getModelDisplayName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (37 * hash) + MODEL_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getModelDisplayName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.AutomlModel}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource.AutomlModel)
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlModel_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlModel_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.class,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        model_ = "";
        modelDisplayName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlModel_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel build() {
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel buildPartial() {
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel result =
            new com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.model_ = model_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.modelDisplayName_ = modelDisplayName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) {
          return mergeFrom((com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel other) {
        if (other
            == com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance())
          return this;
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getModelDisplayName().isEmpty()) {
          modelDisplayName_ = other.modelDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  modelDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Model.
       * Format:
       * `projects/{project}/locations/{location}/models/{model}`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object modelDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * The Model's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string model_display_name = 3;</code>
       *
       * @return The modelDisplayName.
       */
      public java.lang.String getModelDisplayName() {
        java.lang.Object ref = modelDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Model's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string model_display_name = 3;</code>
       *
       * @return The bytes for modelDisplayName.
       */
      public com.google.protobuf.ByteString getModelDisplayNameBytes() {
        java.lang.Object ref = modelDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Model's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string model_display_name = 3;</code>
       *
       * @param value The modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Model's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string model_display_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelDisplayName() {
        modelDisplayName_ = getDefaultInstance().getModelDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Model's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string model_display_name = 3;</code>
       *
       * @param value The bytes for modelDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setModelDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource.AutomlModel)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource.AutomlModel)
    private static final com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel();
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutomlModel> PARSER =
        new com.google.protobuf.AbstractParser<AutomlModel>() {
          @java.lang.Override
          public AutomlModel parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutomlModel> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutomlModel> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutomlDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * The Dataset's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The datasetDisplayName.
     */
    java.lang.String getDatasetDisplayName();
    /**
     *
     *
     * <pre>
     * The Dataset's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    com.google.protobuf.ByteString getDatasetDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents one Dataset in automl.googleapis.com.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.AutomlDataset}
   */
  public static final class AutomlDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)
      AutomlDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutomlDataset.newBuilder() to construct.
    private AutomlDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutomlDataset() {
      dataset_ = "";
      datasetDisplayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutomlDataset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.class,
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder.class);
    }

    public static final int DATASET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of automl Dataset.
     * Format:
     * `projects/{project}/locations/{location}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_DISPLAY_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object datasetDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The Dataset's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The datasetDisplayName.
     */
    @java.lang.Override
    public java.lang.String getDatasetDisplayName() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Dataset's display name in automl.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, datasetDisplayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, datasetDisplayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset other =
          (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) obj;

      if (!getDataset().equals(other.getDataset())) return false;
      if (!getDatasetDisplayName().equals(other.getDatasetDisplayName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      hash = (37 * hash) + DATASET_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetDisplayName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.AutomlDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.class,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataset_ = "";
        datasetDisplayName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_AutomlDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset build() {
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset buildPartial() {
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset result =
            new com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataset_ = dataset_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datasetDisplayName_ = datasetDisplayName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) {
          return mergeFrom((com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset other) {
        if (other
            == com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance())
          return this;
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDatasetDisplayName().isEmpty()) {
          datasetDisplayName_ = other.datasetDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataset_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 34:
                {
                  datasetDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataset_ = "";
      /**
       *
       *
       * <pre>
       * Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        dataset_ = getDefaultInstance().getDataset();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of automl Dataset.
       * Format:
       * `projects/{project}/locations/{location}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object datasetDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * The Dataset's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return The datasetDisplayName.
       */
      public java.lang.String getDatasetDisplayName() {
        java.lang.Object ref = datasetDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return The bytes for datasetDisplayName.
       */
      public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
        java.lang.Object ref = datasetDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @param value The datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetDisplayName() {
        datasetDisplayName_ = getDefaultInstance().getDatasetDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in automl.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @param value The bytes for datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        datasetDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource.AutomlDataset)
    private static final com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset();
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutomlDataset> PARSER =
        new com.google.protobuf.AbstractParser<AutomlDataset>() {
          @java.lang.Override
          public AutomlDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutomlDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutomlDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataLabelingDatasetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * The Dataset's display name in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The datasetDisplayName.
     */
    java.lang.String getDatasetDisplayName();
    /**
     *
     *
     * <pre>
     * The Dataset's display name in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    com.google.protobuf.ByteString getDatasetDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    java.util.List<
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset>
        getDataLabelingAnnotatedDatasetsList();
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .DataLabelingAnnotatedDataset
        getDataLabelingAnnotatedDatasets(int index);
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    int getDataLabelingAnnotatedDatasetsCount();
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDatasetOrBuilder>
        getDataLabelingAnnotatedDatasetsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .DataLabelingAnnotatedDatasetOrBuilder
        getDataLabelingAnnotatedDatasetsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents one Dataset in datalabeling.googleapis.com.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset}
   */
  public static final class DataLabelingDataset extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
      DataLabelingDatasetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataLabelingDataset.newBuilder() to construct.
    private DataLabelingDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataLabelingDataset() {
      dataset_ = "";
      datasetDisplayName_ = "";
      dataLabelingAnnotatedDatasets_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataLabelingDataset();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.class,
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder.class);
    }

    public interface DataLabelingAnnotatedDatasetOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The annotatedDataset.
       */
      java.lang.String getAnnotatedDataset();
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for annotatedDataset.
       */
      com.google.protobuf.ByteString getAnnotatedDatasetBytes();

      /**
       *
       *
       * <pre>
       * The AnnotatedDataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string annotated_dataset_display_name = 3;</code>
       *
       * @return The annotatedDatasetDisplayName.
       */
      java.lang.String getAnnotatedDatasetDisplayName();
      /**
       *
       *
       * <pre>
       * The AnnotatedDataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string annotated_dataset_display_name = 3;</code>
       *
       * @return The bytes for annotatedDatasetDisplayName.
       */
      com.google.protobuf.ByteString getAnnotatedDatasetDisplayNameBytes();
    }
    /**
     *
     *
     * <pre>
     * Represents one AnnotatedDataset in datalabeling.googleapis.com.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset}
     */
    public static final class DataLabelingAnnotatedDataset
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset)
        DataLabelingAnnotatedDatasetOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DataLabelingAnnotatedDataset.newBuilder() to construct.
      private DataLabelingAnnotatedDataset(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DataLabelingAnnotatedDataset() {
        annotatedDataset_ = "";
        annotatedDatasetDisplayName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DataLabelingAnnotatedDataset();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_DataLabelingAnnotatedDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_DataLabelingAnnotatedDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset.class,
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset.Builder.class);
      }

      public static final int ANNOTATED_DATASET_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object annotatedDataset_ = "";
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The annotatedDataset.
       */
      @java.lang.Override
      public java.lang.String getAnnotatedDataset() {
        java.lang.Object ref = annotatedDataset_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          annotatedDataset_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling AnnotatedDataset.
       * Format:
       * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
       * </pre>
       *
       * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for annotatedDataset.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAnnotatedDatasetBytes() {
        java.lang.Object ref = annotatedDataset_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          annotatedDataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ANNOTATED_DATASET_DISPLAY_NAME_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object annotatedDatasetDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * The AnnotatedDataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string annotated_dataset_display_name = 3;</code>
       *
       * @return The annotatedDatasetDisplayName.
       */
      @java.lang.Override
      public java.lang.String getAnnotatedDatasetDisplayName() {
        java.lang.Object ref = annotatedDatasetDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          annotatedDatasetDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The AnnotatedDataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string annotated_dataset_display_name = 3;</code>
       *
       * @return The bytes for annotatedDatasetDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAnnotatedDatasetDisplayNameBytes() {
        java.lang.Object ref = annotatedDatasetDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          annotatedDatasetDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotatedDataset_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotatedDataset_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotatedDatasetDisplayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, annotatedDatasetDisplayName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotatedDataset_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotatedDataset_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotatedDatasetDisplayName_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  3, annotatedDatasetDisplayName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset
            other =
                (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                        .DataLabelingAnnotatedDataset)
                    obj;

        if (!getAnnotatedDataset().equals(other.getAnnotatedDataset())) return false;
        if (!getAnnotatedDatasetDisplayName().equals(other.getAnnotatedDatasetDisplayName()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ANNOTATED_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotatedDataset().hashCode();
        hash = (37 * hash) + ANNOTATED_DATASET_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotatedDatasetDisplayName().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents one AnnotatedDataset in datalabeling.googleapis.com.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset)
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDatasetOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.MigratableResourceProto
              .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_DataLabelingAnnotatedDataset_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.MigratableResourceProto
              .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_DataLabelingAnnotatedDataset_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset.class,
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          annotatedDataset_ = "";
          annotatedDatasetDisplayName_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.MigratableResourceProto
              .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_DataLabelingAnnotatedDataset_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset
            build() {
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset
            buildPartial() {
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              result =
                  new com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.annotatedDataset_ = annotatedDataset_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.annotatedDatasetDisplayName_ = annotatedDatasetDisplayName_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                        .DataLabelingAnnotatedDataset)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset
                other) {
          if (other
              == com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.getDefaultInstance()) return this;
          if (!other.getAnnotatedDataset().isEmpty()) {
            annotatedDataset_ = other.annotatedDataset_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getAnnotatedDatasetDisplayName().isEmpty()) {
            annotatedDatasetDisplayName_ = other.annotatedDatasetDisplayName_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    annotatedDataset_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 26:
                  {
                    annotatedDatasetDisplayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object annotatedDataset_ = "";
        /**
         *
         *
         * <pre>
         * Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The annotatedDataset.
         */
        public java.lang.String getAnnotatedDataset() {
          java.lang.Object ref = annotatedDataset_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            annotatedDataset_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for annotatedDataset.
         */
        public com.google.protobuf.ByteString getAnnotatedDatasetBytes() {
          java.lang.Object ref = annotatedDataset_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            annotatedDataset_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The annotatedDataset to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDataset(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          annotatedDataset_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAnnotatedDataset() {
          annotatedDataset_ = getDefaultInstance().getAnnotatedDataset();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Full resource name of data labeling AnnotatedDataset.
         * Format:
         * `projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}`.
         * </pre>
         *
         * <code>string annotated_dataset = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for annotatedDataset to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDatasetBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          annotatedDataset_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object annotatedDatasetDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         * </pre>
         *
         * <code>string annotated_dataset_display_name = 3;</code>
         *
         * @return The annotatedDatasetDisplayName.
         */
        public java.lang.String getAnnotatedDatasetDisplayName() {
          java.lang.Object ref = annotatedDatasetDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            annotatedDatasetDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         * </pre>
         *
         * <code>string annotated_dataset_display_name = 3;</code>
         *
         * @return The bytes for annotatedDatasetDisplayName.
         */
        public com.google.protobuf.ByteString getAnnotatedDatasetDisplayNameBytes() {
          java.lang.Object ref = annotatedDatasetDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            annotatedDatasetDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         * </pre>
         *
         * <code>string annotated_dataset_display_name = 3;</code>
         *
         * @param value The annotatedDatasetDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDatasetDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          annotatedDatasetDisplayName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         * </pre>
         *
         * <code>string annotated_dataset_display_name = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAnnotatedDatasetDisplayName() {
          annotatedDatasetDisplayName_ = getDefaultInstance().getAnnotatedDatasetDisplayName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         * </pre>
         *
         * <code>string annotated_dataset_display_name = 3;</code>
         *
         * @param value The bytes for annotatedDatasetDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setAnnotatedDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          annotatedDatasetDisplayName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset)
      private static final com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset();
      }

      public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DataLabelingAnnotatedDataset> PARSER =
          new com.google.protobuf.AbstractParser<DataLabelingAnnotatedDataset>() {
            @java.lang.Override
            public DataLabelingAnnotatedDataset parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DataLabelingAnnotatedDataset> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DataLabelingAnnotatedDataset> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DATASET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full resource name of data labeling Dataset.
     * Format:
     * `projects/{project}/datasets/{dataset}`.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_DISPLAY_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object datasetDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The Dataset's display name in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The datasetDisplayName.
     */
    @java.lang.Override
    public java.lang.String getDatasetDisplayName() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datasetDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Dataset's display name in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>string dataset_display_name = 4;</code>
     *
     * @return The bytes for datasetDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
      java.lang.Object ref = datasetDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datasetDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_LABELING_ANNOTATED_DATASETS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset>
        dataLabelingAnnotatedDatasets_;
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .DataLabelingAnnotatedDataset>
        getDataLabelingAnnotatedDatasetsList() {
      return dataLabelingAnnotatedDatasets_;
    }
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDatasetOrBuilder>
        getDataLabelingAnnotatedDatasetsOrBuilderList() {
      return dataLabelingAnnotatedDatasets_;
    }
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    @java.lang.Override
    public int getDataLabelingAnnotatedDatasetsCount() {
      return dataLabelingAnnotatedDatasets_.size();
    }
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .DataLabelingAnnotatedDataset
        getDataLabelingAnnotatedDatasets(int index) {
      return dataLabelingAnnotatedDatasets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
     * the data labeling Dataset.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .DataLabelingAnnotatedDatasetOrBuilder
        getDataLabelingAnnotatedDatasetsOrBuilder(int index) {
      return dataLabelingAnnotatedDatasets_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      for (int i = 0; i < dataLabelingAnnotatedDatasets_.size(); i++) {
        output.writeMessage(3, dataLabelingAnnotatedDatasets_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, datasetDisplayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      for (int i = 0; i < dataLabelingAnnotatedDatasets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, dataLabelingAnnotatedDatasets_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datasetDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, datasetDisplayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset other =
          (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) obj;

      if (!getDataset().equals(other.getDataset())) return false;
      if (!getDatasetDisplayName().equals(other.getDatasetDisplayName())) return false;
      if (!getDataLabelingAnnotatedDatasetsList()
          .equals(other.getDataLabelingAnnotatedDatasetsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      hash = (37 * hash) + DATASET_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetDisplayName().hashCode();
      if (getDataLabelingAnnotatedDatasetsCount() > 0) {
        hash = (37 * hash) + DATA_LABELING_ANNOTATED_DATASETS_FIELD_NUMBER;
        hash = (53 * hash) + getDataLabelingAnnotatedDatasetsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.class,
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataset_ = "";
        datasetDisplayName_ = "";
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          dataLabelingAnnotatedDatasets_ = java.util.Collections.emptyList();
        } else {
          dataLabelingAnnotatedDatasets_ = null;
          dataLabelingAnnotatedDatasetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.MigratableResourceProto
            .internal_static_google_cloud_aiplatform_v1_MigratableResource_DataLabelingDataset_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset build() {
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset buildPartial() {
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset result =
            new com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset result) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            dataLabelingAnnotatedDatasets_ =
                java.util.Collections.unmodifiableList(dataLabelingAnnotatedDatasets_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.dataLabelingAnnotatedDatasets_ = dataLabelingAnnotatedDatasets_;
        } else {
          result.dataLabelingAnnotatedDatasets_ = dataLabelingAnnotatedDatasetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataset_ = dataset_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datasetDisplayName_ = datasetDisplayName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset other) {
        if (other
            == com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                .getDefaultInstance()) return this;
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDatasetDisplayName().isEmpty()) {
          datasetDisplayName_ = other.datasetDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          if (!other.dataLabelingAnnotatedDatasets_.isEmpty()) {
            if (dataLabelingAnnotatedDatasets_.isEmpty()) {
              dataLabelingAnnotatedDatasets_ = other.dataLabelingAnnotatedDatasets_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDataLabelingAnnotatedDatasetsIsMutable();
              dataLabelingAnnotatedDatasets_.addAll(other.dataLabelingAnnotatedDatasets_);
            }
            onChanged();
          }
        } else {
          if (!other.dataLabelingAnnotatedDatasets_.isEmpty()) {
            if (dataLabelingAnnotatedDatasetsBuilder_.isEmpty()) {
              dataLabelingAnnotatedDatasetsBuilder_.dispose();
              dataLabelingAnnotatedDatasetsBuilder_ = null;
              dataLabelingAnnotatedDatasets_ = other.dataLabelingAnnotatedDatasets_;
              bitField0_ = (bitField0_ & ~0x00000004);
              dataLabelingAnnotatedDatasetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDataLabelingAnnotatedDatasetsFieldBuilder()
                      : null;
            } else {
              dataLabelingAnnotatedDatasetsBuilder_.addAllMessages(
                  other.dataLabelingAnnotatedDatasets_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataset_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                          .DataLabelingAnnotatedDataset
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                                  .DataLabelingAnnotatedDataset.parser(),
                              extensionRegistry);
                  if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
                    ensureDataLabelingAnnotatedDatasetsIsMutable();
                    dataLabelingAnnotatedDatasets_.add(m);
                  } else {
                    dataLabelingAnnotatedDatasetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  datasetDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataset_ = "";
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        dataset_ = getDefaultInstance().getDataset();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full resource name of data labeling Dataset.
       * Format:
       * `projects/{project}/datasets/{dataset}`.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object datasetDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * The Dataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return The datasetDisplayName.
       */
      public java.lang.String getDatasetDisplayName() {
        java.lang.Object ref = datasetDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          datasetDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return The bytes for datasetDisplayName.
       */
      public com.google.protobuf.ByteString getDatasetDisplayNameBytes() {
        java.lang.Object ref = datasetDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          datasetDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @param value The datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetDisplayName() {
        datasetDisplayName_ = getDefaultInstance().getDatasetDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Dataset's display name in datalabeling.googleapis.com.
       * </pre>
       *
       * <code>string dataset_display_name = 4;</code>
       *
       * @param value The bytes for datasetDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        datasetDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset>
          dataLabelingAnnotatedDatasets_ = java.util.Collections.emptyList();

      private void ensureDataLabelingAnnotatedDatasetsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          dataLabelingAnnotatedDatasets_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset>(dataLabelingAnnotatedDatasets_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset,
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder,
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDatasetOrBuilder>
          dataLabelingAnnotatedDatasetsBuilder_;

      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset>
          getDataLabelingAnnotatedDatasetsList() {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dataLabelingAnnotatedDatasets_);
        } else {
          return dataLabelingAnnotatedDatasetsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public int getDataLabelingAnnotatedDatasetsCount() {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          return dataLabelingAnnotatedDatasets_.size();
        } else {
          return dataLabelingAnnotatedDatasetsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset
          getDataLabelingAnnotatedDatasets(int index) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          return dataLabelingAnnotatedDatasets_.get(index);
        } else {
          return dataLabelingAnnotatedDatasetsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder setDataLabelingAnnotatedDatasets(
          int index,
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              value) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.set(index, value);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder setDataLabelingAnnotatedDatasets(
          int index,
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder
              builderForValue) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder addDataLabelingAnnotatedDatasets(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              value) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.add(value);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder addDataLabelingAnnotatedDatasets(
          int index,
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset
              value) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.add(index, value);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder addDataLabelingAnnotatedDatasets(
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder
              builderForValue) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.add(builderForValue.build());
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder addDataLabelingAnnotatedDatasets(
          int index,
          com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder
              builderForValue) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder addAllDataLabelingAnnotatedDatasets(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                          .DataLabelingAnnotatedDataset>
              values) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, dataLabelingAnnotatedDatasets_);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder clearDataLabelingAnnotatedDatasets() {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          dataLabelingAnnotatedDatasets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public Builder removeDataLabelingAnnotatedDatasets(int index) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          ensureDataLabelingAnnotatedDatasetsIsMutable();
          dataLabelingAnnotatedDatasets_.remove(index);
          onChanged();
        } else {
          dataLabelingAnnotatedDatasetsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset.Builder
          getDataLabelingAnnotatedDatasetsBuilder(int index) {
        return getDataLabelingAnnotatedDatasetsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDatasetOrBuilder
          getDataLabelingAnnotatedDatasetsOrBuilder(int index) {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          return dataLabelingAnnotatedDatasets_.get(index);
        } else {
          return dataLabelingAnnotatedDatasetsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDatasetOrBuilder>
          getDataLabelingAnnotatedDatasetsOrBuilderList() {
        if (dataLabelingAnnotatedDatasetsBuilder_ != null) {
          return dataLabelingAnnotatedDatasetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dataLabelingAnnotatedDatasets_);
        }
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset.Builder
          addDataLabelingAnnotatedDatasetsBuilder() {
        return getDataLabelingAnnotatedDatasetsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
              .DataLabelingAnnotatedDataset.Builder
          addDataLabelingAnnotatedDatasetsBuilder(int index) {
        return getDataLabelingAnnotatedDatasetsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .DataLabelingAnnotatedDataset.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to
       * the data labeling Dataset.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.DataLabelingAnnotatedDataset data_labeling_annotated_datasets = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder>
          getDataLabelingAnnotatedDatasetsBuilderList() {
        return getDataLabelingAnnotatedDatasetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset,
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDataset.Builder,
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .DataLabelingAnnotatedDatasetOrBuilder>
          getDataLabelingAnnotatedDatasetsFieldBuilder() {
        if (dataLabelingAnnotatedDatasetsBuilder_ == null) {
          dataLabelingAnnotatedDatasetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset,
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDataset.Builder,
                  com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                      .DataLabelingAnnotatedDatasetOrBuilder>(
                  dataLabelingAnnotatedDatasets_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          dataLabelingAnnotatedDatasets_ = null;
        }
        return dataLabelingAnnotatedDatasetsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
    private static final com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset();
    }

    public static com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataLabelingDataset> PARSER =
        new com.google.protobuf.AbstractParser<DataLabelingDataset>() {
          @java.lang.Override
          public DataLabelingDataset parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataLabelingDataset> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataLabelingDataset> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int resourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object resource_;

  public enum ResourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ML_ENGINE_MODEL_VERSION(1),
    AUTOML_MODEL(2),
    AUTOML_DATASET(3),
    DATA_LABELING_DATASET(4),
    RESOURCE_NOT_SET(0);
    private final int value;

    private ResourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return ML_ENGINE_MODEL_VERSION;
        case 2:
          return AUTOML_MODEL;
        case 3:
          return AUTOML_DATASET;
        case 4:
          return DATA_LABELING_DATASET;
        case 0:
          return RESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResourceCase getResourceCase() {
    return ResourceCase.forNumber(resourceCase_);
  }

  public static final int ML_ENGINE_MODEL_VERSION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Output only. Represents one Version in ml.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the mlEngineModelVersion field is set.
   */
  @java.lang.Override
  public boolean hasMlEngineModelVersion() {
    return resourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Version in ml.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The mlEngineModelVersion.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
      getMlEngineModelVersion() {
    if (resourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Version in ml.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder
      getMlEngineModelVersionOrBuilder() {
    if (resourceCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        .getDefaultInstance();
  }

  public static final int AUTOML_MODEL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Output only. Represents one Model in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the automlModel field is set.
   */
  @java.lang.Override
  public boolean hasAutomlModel() {
    return resourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Model in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The automlModel.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel getAutomlModel() {
    if (resourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Model in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder
      getAutomlModelOrBuilder() {
    if (resourceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
  }

  public static final int AUTOML_DATASET_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the automlDataset field is set.
   */
  @java.lang.Override
  public boolean hasAutomlDataset() {
    return resourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The automlDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset getAutomlDataset() {
    if (resourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in automl.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder
      getAutomlDatasetOrBuilder() {
    if (resourceCase_ == 3) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
  }

  public static final int DATA_LABELING_DATASET_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in datalabeling.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataLabelingDataset field is set.
   */
  @java.lang.Override
  public boolean hasDataLabelingDataset() {
    return resourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in datalabeling.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataLabelingDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
      getDataLabelingDataset() {
    if (resourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents one Dataset in datalabeling.googleapis.com.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder
      getDataLabelingDatasetOrBuilder() {
    if (resourceCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_;
    }
    return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        .getDefaultInstance();
  }

  public static final int LAST_MIGRATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp lastMigrateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the last migration attempt on this
   * MigratableResource started. Will not be set if there's no migration attempt
   * on this MigratableResource.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastMigrateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastMigrateTime() {
    return lastMigrateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the last migration attempt on this
   * MigratableResource started. Will not be set if there's no migration attempt
   * on this MigratableResource.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastMigrateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastMigrateTime() {
    return lastMigrateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastMigrateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when the last migration attempt on this
   * MigratableResource started. Will not be set if there's no migration attempt
   * on this MigratableResource.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastMigrateTimeOrBuilder() {
    return lastMigrateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastMigrateTime_;
  }

  public static final int LAST_UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp lastUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this MigratableResource was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasLastUpdateTime() {
    return lastUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this MigratableResource was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastUpdateTime() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this MigratableResource was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
    return lastUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastUpdateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_);
    }
    if (resourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_);
    }
    if (resourceCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_);
    }
    if (resourceCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_);
    }
    if (lastMigrateTime_ != null) {
      output.writeMessage(5, getLastMigrateTime());
    }
    if (lastUpdateTime_ != null) {
      output.writeMessage(6, getLastUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_);
    }
    if (resourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_);
    }
    if (resourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_);
    }
    if (resourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_);
    }
    if (lastMigrateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLastMigrateTime());
    }
    if (lastUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLastUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.MigratableResource)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.MigratableResource other =
        (com.google.cloud.aiplatform.v1.MigratableResource) obj;

    if (hasLastMigrateTime() != other.hasLastMigrateTime()) return false;
    if (hasLastMigrateTime()) {
      if (!getLastMigrateTime().equals(other.getLastMigrateTime())) return false;
    }
    if (hasLastUpdateTime() != other.hasLastUpdateTime()) return false;
    if (hasLastUpdateTime()) {
      if (!getLastUpdateTime().equals(other.getLastUpdateTime())) return false;
    }
    if (!getResourceCase().equals(other.getResourceCase())) return false;
    switch (resourceCase_) {
      case 1:
        if (!getMlEngineModelVersion().equals(other.getMlEngineModelVersion())) return false;
        break;
      case 2:
        if (!getAutomlModel().equals(other.getAutomlModel())) return false;
        break;
      case 3:
        if (!getAutomlDataset().equals(other.getAutomlDataset())) return false;
        break;
      case 4:
        if (!getDataLabelingDataset().equals(other.getDataLabelingDataset())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLastMigrateTime()) {
      hash = (37 * hash) + LAST_MIGRATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastMigrateTime().hashCode();
    }
    if (hasLastUpdateTime()) {
      hash = (37 * hash) + LAST_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastUpdateTime().hashCode();
    }
    switch (resourceCase_) {
      case 1:
        hash = (37 * hash) + ML_ENGINE_MODEL_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getMlEngineModelVersion().hashCode();
        break;
      case 2:
        hash = (37 * hash) + AUTOML_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getAutomlModel().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AUTOML_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getAutomlDataset().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DATA_LABELING_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getDataLabelingDataset().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.MigratableResource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents one resource that exists in automl.googleapis.com,
   * datalabeling.googleapis.com or ml.googleapis.com.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.MigratableResource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.MigratableResource)
      com.google.cloud.aiplatform.v1.MigratableResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.MigratableResource.class,
              com.google.cloud.aiplatform.v1.MigratableResource.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.MigratableResource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (mlEngineModelVersionBuilder_ != null) {
        mlEngineModelVersionBuilder_.clear();
      }
      if (automlModelBuilder_ != null) {
        automlModelBuilder_.clear();
      }
      if (automlDatasetBuilder_ != null) {
        automlDatasetBuilder_.clear();
      }
      if (dataLabelingDatasetBuilder_ != null) {
        dataLabelingDatasetBuilder_.clear();
      }
      lastMigrateTime_ = null;
      if (lastMigrateTimeBuilder_ != null) {
        lastMigrateTimeBuilder_.dispose();
        lastMigrateTimeBuilder_ = null;
      }
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      resourceCase_ = 0;
      resource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.MigratableResourceProto
          .internal_static_google_cloud_aiplatform_v1_MigratableResource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.MigratableResource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource build() {
      com.google.cloud.aiplatform.v1.MigratableResource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource buildPartial() {
      com.google.cloud.aiplatform.v1.MigratableResource result =
          new com.google.cloud.aiplatform.v1.MigratableResource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.MigratableResource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.lastMigrateTime_ =
            lastMigrateTimeBuilder_ == null ? lastMigrateTime_ : lastMigrateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastUpdateTime_ =
            lastUpdateTimeBuilder_ == null ? lastUpdateTime_ : lastUpdateTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.MigratableResource result) {
      result.resourceCase_ = resourceCase_;
      result.resource_ = this.resource_;
      if (resourceCase_ == 1 && mlEngineModelVersionBuilder_ != null) {
        result.resource_ = mlEngineModelVersionBuilder_.build();
      }
      if (resourceCase_ == 2 && automlModelBuilder_ != null) {
        result.resource_ = automlModelBuilder_.build();
      }
      if (resourceCase_ == 3 && automlDatasetBuilder_ != null) {
        result.resource_ = automlDatasetBuilder_.build();
      }
      if (resourceCase_ == 4 && dataLabelingDatasetBuilder_ != null) {
        result.resource_ = dataLabelingDatasetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.MigratableResource) {
        return mergeFrom((com.google.cloud.aiplatform.v1.MigratableResource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.MigratableResource other) {
      if (other == com.google.cloud.aiplatform.v1.MigratableResource.getDefaultInstance())
        return this;
      if (other.hasLastMigrateTime()) {
        mergeLastMigrateTime(other.getLastMigrateTime());
      }
      if (other.hasLastUpdateTime()) {
        mergeLastUpdateTime(other.getLastUpdateTime());
      }
      switch (other.getResourceCase()) {
        case ML_ENGINE_MODEL_VERSION:
          {
            mergeMlEngineModelVersion(other.getMlEngineModelVersion());
            break;
          }
        case AUTOML_MODEL:
          {
            mergeAutomlModel(other.getAutomlModel());
            break;
          }
        case AUTOML_DATASET:
          {
            mergeAutomlDataset(other.getAutomlDataset());
            break;
          }
        case DATA_LABELING_DATASET:
          {
            mergeDataLabelingDataset(other.getDataLabelingDataset());
            break;
          }
        case RESOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getMlEngineModelVersionFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAutomlModelFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAutomlDatasetFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getDataLabelingDatasetFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getLastMigrateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getLastUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resourceCase_ = 0;
    private java.lang.Object resource_;

    public ResourceCase getResourceCase() {
      return ResourceCase.forNumber(resourceCase_);
    }

    public Builder clearResource() {
      resourceCase_ = 0;
      resource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion,
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder>
        mlEngineModelVersionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the mlEngineModelVersion field is set.
     */
    @java.lang.Override
    public boolean hasMlEngineModelVersion() {
      return resourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The mlEngineModelVersion.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
        getMlEngineModelVersion() {
      if (mlEngineModelVersionBuilder_ == null) {
        if (resourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
            .getDefaultInstance();
      } else {
        if (resourceCase_ == 1) {
          return mlEngineModelVersionBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMlEngineModelVersion(
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion value) {
      if (mlEngineModelVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        mlEngineModelVersionBuilder_.setMessage(value);
      }
      resourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMlEngineModelVersion(
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder
            builderForValue) {
      if (mlEngineModelVersionBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        mlEngineModelVersionBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMlEngineModelVersion(
        com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion value) {
      if (mlEngineModelVersionBuilder_ == null) {
        if (resourceCase_ == 1
            && resource_
                != com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
                    .getDefaultInstance()) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.newBuilder(
                      (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion)
                          resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 1) {
          mlEngineModelVersionBuilder_.mergeFrom(value);
        } else {
          mlEngineModelVersionBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMlEngineModelVersion() {
      if (mlEngineModelVersionBuilder_ == null) {
        if (resourceCase_ == 1) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 1) {
          resourceCase_ = 0;
          resource_ = null;
        }
        mlEngineModelVersionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder
        getMlEngineModelVersionBuilder() {
      return getMlEngineModelVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder
        getMlEngineModelVersionOrBuilder() {
      if ((resourceCase_ == 1) && (mlEngineModelVersionBuilder_ != null)) {
        return mlEngineModelVersionBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Version in ml.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion ml_engine_model_version = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion,
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder>
        getMlEngineModelVersionFieldBuilder() {
      if (mlEngineModelVersionBuilder_ == null) {
        if (!(resourceCase_ == 1)) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion
                  .getDefaultInstance();
        }
        mlEngineModelVersionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion,
                com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion.Builder,
                com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersionOrBuilder>(
                (com.google.cloud.aiplatform.v1.MigratableResource.MlEngineModelVersion) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 1;
      onChanged();
      return mlEngineModelVersionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder>
        automlModelBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the automlModel field is set.
     */
    @java.lang.Override
    public boolean hasAutomlModel() {
      return resourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The automlModel.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel getAutomlModel() {
      if (automlModelBuilder_ == null) {
        if (resourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
      } else {
        if (resourceCase_ == 2) {
          return automlModelBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomlModel(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel value) {
      if (automlModelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        automlModelBuilder_.setMessage(value);
      }
      resourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomlModel(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder builderForValue) {
      if (automlModelBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        automlModelBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAutomlModel(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel value) {
      if (automlModelBuilder_ == null) {
        if (resourceCase_ == 2
            && resource_
                != com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel
                    .getDefaultInstance()) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.newBuilder(
                      (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 2) {
          automlModelBuilder_.mergeFrom(value);
        } else {
          automlModelBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAutomlModel() {
      if (automlModelBuilder_ == null) {
        if (resourceCase_ == 2) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 2) {
          resourceCase_ = 0;
          resource_ = null;
        }
        automlModelBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder
        getAutomlModelBuilder() {
      return getAutomlModelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder
        getAutomlModelOrBuilder() {
      if ((resourceCase_ == 2) && (automlModelBuilder_ != null)) {
        return automlModelBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Model in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlModel automl_model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder>
        getAutomlModelFieldBuilder() {
      if (automlModelBuilder_ == null) {
        if (!(resourceCase_ == 2)) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.getDefaultInstance();
        }
        automlModelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel.Builder,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlModelOrBuilder>(
                (com.google.cloud.aiplatform.v1.MigratableResource.AutomlModel) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 2;
      onChanged();
      return automlModelBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder>
        automlDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the automlDataset field is set.
     */
    @java.lang.Override
    public boolean hasAutomlDataset() {
      return resourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The automlDataset.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset getAutomlDataset() {
      if (automlDatasetBuilder_ == null) {
        if (resourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
      } else {
        if (resourceCase_ == 3) {
          return automlDatasetBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomlDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset value) {
      if (automlDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        automlDatasetBuilder_.setMessage(value);
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomlDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder builderForValue) {
      if (automlDatasetBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        automlDatasetBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAutomlDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset value) {
      if (automlDatasetBuilder_ == null) {
        if (resourceCase_ == 3
            && resource_
                != com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset
                    .getDefaultInstance()) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.newBuilder(
                      (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 3) {
          automlDatasetBuilder_.mergeFrom(value);
        } else {
          automlDatasetBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAutomlDataset() {
      if (automlDatasetBuilder_ == null) {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
        }
        automlDatasetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder
        getAutomlDatasetBuilder() {
      return getAutomlDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder
        getAutomlDatasetOrBuilder() {
      if ((resourceCase_ == 3) && (automlDatasetBuilder_ != null)) {
        return automlDatasetBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in automl.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.AutomlDataset automl_dataset = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder>
        getAutomlDatasetFieldBuilder() {
      if (automlDatasetBuilder_ == null) {
        if (!(resourceCase_ == 3)) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.getDefaultInstance();
        }
        automlDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset.Builder,
                com.google.cloud.aiplatform.v1.MigratableResource.AutomlDatasetOrBuilder>(
                (com.google.cloud.aiplatform.v1.MigratableResource.AutomlDataset) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 3;
      onChanged();
      return automlDatasetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset,
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder>
        dataLabelingDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataLabelingDataset field is set.
     */
    @java.lang.Override
    public boolean hasDataLabelingDataset() {
      return resourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataLabelingDataset.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
        getDataLabelingDataset() {
      if (dataLabelingDatasetBuilder_ == null) {
        if (resourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .getDefaultInstance();
      } else {
        if (resourceCase_ == 4) {
          return dataLabelingDatasetBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataLabelingDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset value) {
      if (dataLabelingDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        dataLabelingDatasetBuilder_.setMessage(value);
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataLabelingDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder
            builderForValue) {
      if (dataLabelingDatasetBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        dataLabelingDatasetBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataLabelingDataset(
        com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset value) {
      if (dataLabelingDatasetBuilder_ == null) {
        if (resourceCase_ == 4
            && resource_
                != com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                    .getDefaultInstance()) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.newBuilder(
                      (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset)
                          resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 4) {
          dataLabelingDatasetBuilder_.mergeFrom(value);
        } else {
          dataLabelingDatasetBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataLabelingDataset() {
      if (dataLabelingDatasetBuilder_ == null) {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
        }
        dataLabelingDatasetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder
        getDataLabelingDatasetBuilder() {
      return getDataLabelingDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder
        getDataLabelingDatasetOrBuilder() {
      if ((resourceCase_ == 4) && (dataLabelingDatasetBuilder_ != null)) {
        return dataLabelingDatasetBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_;
        }
        return com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents one Dataset in datalabeling.googleapis.com.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset data_labeling_dataset = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset,
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder,
            com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder>
        getDataLabelingDatasetFieldBuilder() {
      if (dataLabelingDatasetBuilder_ == null) {
        if (!(resourceCase_ == 4)) {
          resource_ =
              com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset
                  .getDefaultInstance();
        }
        dataLabelingDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset,
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset.Builder,
                com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDatasetOrBuilder>(
                (com.google.cloud.aiplatform.v1.MigratableResource.DataLabelingDataset) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 4;
      onChanged();
      return dataLabelingDatasetBuilder_;
    }

    private com.google.protobuf.Timestamp lastMigrateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastMigrateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastMigrateTime field is set.
     */
    public boolean hasLastMigrateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastMigrateTime.
     */
    public com.google.protobuf.Timestamp getLastMigrateTime() {
      if (lastMigrateTimeBuilder_ == null) {
        return lastMigrateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastMigrateTime_;
      } else {
        return lastMigrateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastMigrateTime(com.google.protobuf.Timestamp value) {
      if (lastMigrateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastMigrateTime_ = value;
      } else {
        lastMigrateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastMigrateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastMigrateTimeBuilder_ == null) {
        lastMigrateTime_ = builderForValue.build();
      } else {
        lastMigrateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastMigrateTime(com.google.protobuf.Timestamp value) {
      if (lastMigrateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && lastMigrateTime_ != null
            && lastMigrateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastMigrateTimeBuilder().mergeFrom(value);
        } else {
          lastMigrateTime_ = value;
        }
      } else {
        lastMigrateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastMigrateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      lastMigrateTime_ = null;
      if (lastMigrateTimeBuilder_ != null) {
        lastMigrateTimeBuilder_.dispose();
        lastMigrateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastMigrateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLastMigrateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastMigrateTimeOrBuilder() {
      if (lastMigrateTimeBuilder_ != null) {
        return lastMigrateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastMigrateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastMigrateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when the last migration attempt on this
     * MigratableResource started. Will not be set if there's no migration attempt
     * on this MigratableResource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_migrate_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastMigrateTimeFieldBuilder() {
      if (lastMigrateTimeBuilder_ == null) {
        lastMigrateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastMigrateTime(), getParentForChildren(), isClean());
        lastMigrateTime_ = null;
      }
      return lastMigrateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastUpdateTime field is set.
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastUpdateTime.
     */
    public com.google.protobuf.Timestamp getLastUpdateTime() {
      if (lastUpdateTimeBuilder_ == null) {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      } else {
        return lastUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastUpdateTime_ = value;
      } else {
        lastUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTime_ = builderForValue.build();
      } else {
        lastUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastUpdateTime(com.google.protobuf.Timestamp value) {
      if (lastUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && lastUpdateTime_ != null
            && lastUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastUpdateTimeBuilder().mergeFrom(value);
        } else {
          lastUpdateTime_ = value;
        }
      } else {
        lastUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lastUpdateTime_ = null;
      if (lastUpdateTimeBuilder_ != null) {
        lastUpdateTimeBuilder_.dispose();
        lastUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLastUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastUpdateTimeOrBuilder() {
      if (lastUpdateTimeBuilder_ != null) {
        return lastUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this MigratableResource was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastUpdateTimeFieldBuilder() {
      if (lastUpdateTimeBuilder_ == null) {
        lastUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastUpdateTime(), getParentForChildren(), isClean());
        lastUpdateTime_ = null;
      }
      return lastUpdateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.MigratableResource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.MigratableResource)
  private static final com.google.cloud.aiplatform.v1.MigratableResource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.MigratableResource();
  }

  public static com.google.cloud.aiplatform.v1.MigratableResource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigratableResource> PARSER =
      new com.google.protobuf.AbstractParser<MigratableResource>() {
        @java.lang.Override
        public MigratableResource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigratableResource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigratableResource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.MigratableResource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
